/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components.configuration.configurators;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyDescriptor;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ToolTipManager;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import net.sf.sdedit.ui.components.AutoCompletionComboboxEditor;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.components.configuration.DataObject;
import net.sf.sdedit.ui.components.configuration.configurators.StringConfigurator;
import net.sf.sdedit.ui.components.configuration.configurators.StringSelectionReceiver;

public class SingleStringSelectionConfigurator<C extends DataObject>
extends StringConfigurator<C>
implements ActionListener,
ListCellRenderer,
StringSelectionReceiver {
    private static final long serialVersionUID = 8263390939195390348L;
    protected JComboBox comboBox;
    private BasicComboBoxRenderer renderer = new BasicComboBoxRenderer();

    public SingleStringSelectionConfigurator(Bean<C> bean, PropertyDescriptor property) {
        super(bean, property);
        this.initialize();
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JComponent comp = (JComponent)this.renderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (isSelected && -1 < index) {
            list.setToolTipText((String)this.comboBox.getItemAt(index));
        }
        return comp;
    }

    private void initialize() {
        this.comboBox = new JComboBox();
        this.comboBox.setEditable(true);
        AutoCompletionComboboxEditor editor = new AutoCompletionComboboxEditor(this.comboBox);
        this.comboBox.setEditor(editor);
        this.comboBox.setRenderer(this);
        ToolTipManager.sharedInstance().registerComponent(this.comboBox);
        this.comboBox.addActionListener(this);
        this.getBottomPanel().setLayout(new BorderLayout());
        this.getBottomPanel().add((Component)this.comboBox, "Center");
        this.reinitialize(true);
    }

    @Override
    public void reinitialize() {
        this.reinitialize(false);
    }

    private void reinitialize(boolean init) {
        String oldValue = null;
        if (!((String)this.getValue()).equals(this.getNullValue())) {
            oldValue = (String)this.getValue();
        }
        this.comboBox.removeAllItems();
        Set<String> choices = this.getBean().getStringsForProperty(this.getProperty());
        if (choices.isEmpty() && init && oldValue != null) {
            choices.add(oldValue);
        }
        for (String choice : choices) {
            this.comboBox.addItem(choice);
        }
        if (oldValue != null) {
            this.comboBox.setSelectedItem(oldValue);
        }
        if (choices.isEmpty()) {
            this.applyValue(this.getNullValue());
        }
    }

    @Override
    protected void refresh(String value) {
        this.comboBox.setSelectedItem(value);
    }

    @Override
    protected void _actionPerformed(ActionEvent e) {
        String value = (String)this.comboBox.getSelectedItem();
        this.applyValue(value);
    }

    @Override
    protected void _setEnabled(boolean enabled) {
        this.comboBox.setEnabled(enabled);
    }

    @Override
    public void focus() {
        this.comboBox.requestFocus();
    }
}

