/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXPath;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import java.io.IOException;

public class Input
extends ControlSequence {
    private byte notFoundAction = 0;
    public static final byte NOT_FOUND_ACTION_ERROR = 0;
    public static final byte NOT_FOUND_ACTION_WARN = 1;
    public static final byte NOT_FOUND_ACTION_IGNORE = 2;

    public Input() {
        this("input");
    }

    public Input(String string) {
        this(string, 0);
    }

    public Input(String string, byte by) {
        super(string);
        this.notFoundAction = by;
    }

    @Override
    public Object clone() {
        return new Input(this.getName(), this.notFoundAction);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        Object object;
        TeXObject teXObject = teXObjectList.popArg(teXParser);
        if (teXObject instanceof Expandable && (object = ((Expandable)((Object)teXObject)).expandfully(teXParser, teXObjectList)) != null) {
            teXObject = object;
        }
        if (!this.doInput(teXParser, teXObject)) {
            switch (this.notFoundAction) {
                case 1: {
                    object = teXParser.getListener().getTeXApp();
                    object.warning(teXParser, object.getMessage("tex.error.file.not.found", teXObject.toString(teXParser)));
                    break;
                }
                case 0: {
                    throw new TeXSyntaxException(teXParser, "tex.error.file.not.found", teXObject.toString(teXParser));
                }
            }
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        Object object;
        TeXObject teXObject = teXParser.popNextArg();
        if (teXObject instanceof Expandable && (object = ((Expandable)((Object)teXObject)).expandfully(teXParser)) != null) {
            teXObject = object;
        }
        if (!this.doInput(teXParser, teXObject)) {
            switch (this.notFoundAction) {
                case 1: {
                    object = teXParser.getListener().getTeXApp();
                    object.warning(teXParser, object.getMessage("tex.error.file.not.found", teXObject.toString(teXParser)));
                    break;
                }
                case 0: {
                    throw new TeXSyntaxException(teXParser, "tex.error.file.not.found", teXObject.toString(teXParser));
                }
            }
        }
    }

    protected boolean doInput(TeXParser teXParser, TeXObject teXObject) throws IOException {
        TeXPath teXPath;
        TeXParserListener teXParserListener = teXParser.getListener();
        if (!teXParserListener.input(teXPath = new TeXPath(teXParser, teXObject.toString(teXParser)))) {
            return false;
        }
        teXParserListener.addFileReference(teXPath);
        return true;
    }
}

