/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.primitives;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.primitives.IfFalse;
import com.dickimawbooks.texparserlib.primitives.IfTrue;
import com.dickimawbooks.texparserlib.primitives.Primitive;
import java.io.IOException;

public class NewIf
extends Primitive {
    public NewIf() {
        this("newif");
    }

    public NewIf(String string) {
        super(string);
        this.setAllowsPrefix(true);
    }

    @Override
    public Object clone() {
        return new NewIf(this.getName());
    }

    public static void createConditional(boolean bl, TeXParser teXParser, TeXObject teXObject) throws IOException {
        if (!(teXObject instanceof ControlSequence)) {
            throw new TeXSyntaxException(teXParser, "tex.error.cs_expected", teXObject.toString(teXParser), teXObject.getClass().getSimpleName());
        }
        NewIf.createConditional(bl, teXParser, ((ControlSequence)teXObject).getName());
    }

    public static void createConditional(boolean bl, TeXParser teXParser, String string) {
        NewIf.createConditional(bl, teXParser, string, false);
    }

    public static void createConditional(boolean bl, TeXParser teXParser, String string, boolean bl2) {
        teXParser.putControlSequence(bl, bl2 ? new IfTrue(string) : new IfFalse(string));
        TeXObjectList teXObjectList = new TeXObjectList();
        String string2 = string.substring(2);
        teXObjectList.add(new TeXCsRef("let"));
        teXObjectList.add(new TeXCsRef("if" + string2));
        teXObjectList.add(new TeXCsRef("iffalse"));
        teXParser.putControlSequence(new GenericCommand(true, string2 + "false", null, teXObjectList));
        teXObjectList = new TeXObjectList();
        teXObjectList.add(new TeXCsRef("let"));
        teXObjectList.add(new TeXCsRef("if" + string2));
        teXObjectList.add(new TeXCsRef("iftrue"));
        teXParser.putControlSequence(new GenericCommand(true, string2 + "true", null, teXObjectList));
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        NewIf.createConditional(this.getPrefix() != 2, teXParser, teXObjectList.popToken());
        this.clearPrefix();
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        NewIf.createConditional(this.getPrefix() != 2, teXParser, teXParser.popToken());
        this.clearPrefix();
    }
}

