/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.tikz;

import net.sourceforge.plantuml.tikz.TikzGraphics;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;

public class DriverEllipseTikz
implements UDriver<TikzGraphics> {
    @Override
    public void draw(UShape ushape, double x, double y, ColorMapper mapper, UParam param, TikzGraphics tikz) {
        UEllipse shape = (UEllipse)ushape;
        double width = shape.getWidth();
        double height = shape.getHeight();
        double start = shape.getStart();
        double extend = shape.getExtend();
        double cx = x + width / 2.0;
        double cy = y + height / 2.0;
        tikz.setFillColor(mapper.getMappedColor(param.getBackcolor()));
        tikz.setStrokeColor(mapper.getMappedColor(param.getColor()));
        tikz.setStrokeWidth(param.getStroke().getThickness(), param.getStroke().getDashTikz());
        if (start == 0.0 && extend == 0.0) {
            tikz.ellipse(cx, cy, width / 2.0, height / 2.0);
        } else {
            double x1 = cx + Math.sin((start += 90.0) * Math.PI / 180.0) * width / 2.0;
            double y1 = cy + Math.cos(start * Math.PI / 180.0) * height / 2.0;
            double x2 = cx + Math.sin((start + extend) * Math.PI / 180.0) * width / 2.0;
            double y2 = cy + Math.cos((start + extend) * Math.PI / 180.0) * height / 2.0;
            tikz.arc(x1, y1, (int)(360.0 - (start + 270.0)), (int)(360.0 - (start + 270.0 + extend)), (width + height) / 4.0);
        }
    }
}

