/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bib2gls.GlsResource;
import com.dickimawbooks.texparserlib.Command;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import java.io.IOException;

public class GlsUseField
extends Command {
    protected Bib2Gls bib2gls;
    public static final int CASE_NO_CHANGE = 0;
    public static final int CASE_SENTENCE = 1;
    public static final int CASE_TO_UPPER = 2;
    public static final int CASE_TITLE_CASE = 3;
    private int caseChange = 0;

    public GlsUseField(Bib2Gls bib2Gls) {
        this("glsxtrusefield", 0, bib2Gls);
    }

    public GlsUseField(String string, Bib2Gls bib2Gls) {
        this(string, 0, bib2Gls);
    }

    public GlsUseField(String string, int n, Bib2Gls bib2Gls) {
        super(string);
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.caseChange = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid case change " + n);
            }
        }
        this.bib2gls = bib2Gls;
    }

    @Override
    public Object clone() {
        return new GlsUseField(this.getName(), this.getCaseChange(), this.bib2gls);
    }

    public int getCaseChange() {
        return this.caseChange;
    }

    protected Bib2GlsEntry fetchEntry(String string) throws IOException {
        GlsResource glsResource = this.bib2gls.getCurrentResource();
        Bib2GlsEntry bib2GlsEntry = glsResource.getEntry(string);
        if (bib2GlsEntry == null) {
            if (this.bib2gls.getDebugLevel() > 0) {
                this.bib2gls.debug(String.format("\\%s -> %s", this.getName(), this.bib2gls.getMessage("warning.unknown_entry_in_current_resource", string, glsResource)));
            }
            for (GlsResource glsResource2 : this.bib2gls.getResources()) {
                if (glsResource2 == glsResource || (bib2GlsEntry = glsResource2.getEntry(string)) == null) continue;
                if (this.bib2gls.getDebugLevel() <= 0) break;
                this.bib2gls.debug(String.format("\\%s -> %s", this.getName(), this.bib2gls.getMessage("message.found_entry_in_resource", string, glsResource2)));
                break;
            }
            if (bib2GlsEntry == null) {
                this.bib2gls.warning(String.format("\\%s -> %s", this.getName(), this.bib2gls.getMessage("warning.unknown_entry", string)));
            }
        }
        return bib2GlsEntry;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser, teXParser);
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        Object object;
        Object object2;
        Object object3 = teXParser == teXObjectList ? teXParser.popNextArg() : teXObjectList.popArg(teXParser);
        if (object3 instanceof Expandable && (object2 = teXParser == teXObjectList ? ((Expandable)object3).expandfully(teXParser) : ((Expandable)object3).expandfully(teXParser, teXObjectList)) != null) {
            object3 = object2;
        }
        object2 = object3.toString(teXParser);
        object3 = teXParser == teXObjectList ? teXParser.popNextArg() : teXObjectList.popArg(teXParser);
        if (object3 instanceof Expandable && (object = teXParser == teXObjectList ? ((Expandable)object3).expandfully(teXParser) : ((Expandable)object3).expandfully(teXParser, teXObjectList)) != null) {
            object3 = object;
        }
        object = object3.toString(teXParser);
        TeXObjectList teXObjectList2 = new TeXObjectList();
        this.process(teXParser, (String)object2, (String)object, teXObjectList2);
        return teXObjectList2;
    }

    protected void process(TeXParser teXParser, String string, String string2, TeXObjectList teXObjectList) throws IOException {
        Bib2GlsEntry bib2GlsEntry = this.fetchEntry(string);
        if (bib2GlsEntry == null) {
            return;
        }
        this.process(teXParser, bib2GlsEntry, string2, this.caseChange, teXObjectList);
    }

    protected void process(TeXParser teXParser, Bib2GlsEntry bib2GlsEntry, String string, int n, TeXObjectList teXObjectList) throws IOException {
        BibValueList bibValueList = bib2GlsEntry.getField(string);
        if (bibValueList == null) {
            bibValueList = bib2GlsEntry.getFallbackContents(string);
        }
        if (bibValueList == null) {
            this.bib2gls.warning(String.format("\\%s{%s} -> %s", this.getName(), bib2GlsEntry.getId(), this.bib2gls.getMessage("message.field.not.set", string)));
            return;
        }
        TeXObjectList teXObjectList2 = ((BibValueList)bibValueList.clone()).expand(teXParser);
        switch (n) {
            case 1: {
                this.bib2gls.getCurrentResource().toSentenceCase(teXObjectList2, teXParser.getListener());
                break;
            }
            case 2: {
                this.bib2gls.getCurrentResource().toUpperCase(teXObjectList2, teXParser.getListener());
                break;
            }
            case 3: {
                this.bib2gls.getCurrentResource().toTitleCase(teXObjectList2, teXParser.getListener());
            }
        }
        teXObjectList.add(teXObjectList2);
    }
}

