/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.coredump;

import com.sun.tools.visualvm.core.datasource.Storage;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import com.sun.tools.visualvm.core.datasupport.Utils;
import com.sun.tools.visualvm.core.model.ModelProvider;
import com.sun.tools.visualvm.core.snapshot.RegisteredSnapshotCategories;
import com.sun.tools.visualvm.core.snapshot.SnapshotCategory;
import com.sun.tools.visualvm.core.ui.DataSourceViewProvider;
import com.sun.tools.visualvm.core.ui.DataSourceViewsManager;
import com.sun.tools.visualvm.core.ui.PluggableDataSourceViewProvider;
import com.sun.tools.visualvm.coredump.CoreDump;
import com.sun.tools.visualvm.coredump.CoreDumpsContainer;
import com.sun.tools.visualvm.coredump.impl.CoreDumpCategory;
import com.sun.tools.visualvm.coredump.impl.CoreDumpDescriptorProvider;
import com.sun.tools.visualvm.coredump.impl.CoreDumpOverviewViewProvider;
import com.sun.tools.visualvm.coredump.impl.CoreDumpProvider;
import java.io.File;

public final class CoreDumpSupport {
    private static final String COREDUMPS_STORAGE_DIRNAME = "coredumps";
    private static final Object coredumpsStorageDirectoryLock = new Object();
    private static File coredumpsStorageDirectory;
    private static final Object coredumpsStorageDirectoryStringLock;
    private static String coredumpsStorageDirectoryString;
    private static CoreDumpOverviewViewProvider viewProvider;
    private static CoreDumpCategory category;
    private static final Object currentJDKHomeLock;
    private static String currentJDKHome;

    public static PluggableDataSourceViewProvider<CoreDump> getOverviewView() {
        return viewProvider;
    }

    public static SnapshotCategory getCategory() {
        return category;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCurrentJDKHome() {
        Object object = currentJDKHomeLock;
        synchronized (object) {
            String jreSuffix;
            if (currentJDKHome == null && (currentJDKHome = System.getProperty("java.home")).endsWith(jreSuffix = File.separator + "jre")) {
                currentJDKHome = currentJDKHome.substring(0, currentJDKHome.length() - jreSuffix.length());
            }
            return currentJDKHome;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getStorageDirectoryString() {
        Object object = coredumpsStorageDirectoryStringLock;
        synchronized (object) {
            if (coredumpsStorageDirectoryString == null) {
                coredumpsStorageDirectoryString = Storage.getPersistentStorageDirectoryString() + File.separator + COREDUMPS_STORAGE_DIRNAME;
            }
            return coredumpsStorageDirectoryString;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getStorageDirectory() {
        Object object = coredumpsStorageDirectoryLock;
        synchronized (object) {
            if (coredumpsStorageDirectory == null) {
                String snapshotsStorageString = CoreDumpSupport.getStorageDirectoryString();
                coredumpsStorageDirectory = new File(snapshotsStorageString);
                if (coredumpsStorageDirectory.exists() && coredumpsStorageDirectory.isFile()) {
                    throw new IllegalStateException("Cannot create coredumps storage directory " + snapshotsStorageString + ", file in the way");
                }
                if (!(!coredumpsStorageDirectory.exists() || coredumpsStorageDirectory.canRead() && coredumpsStorageDirectory.canWrite())) {
                    throw new IllegalStateException("Cannot access coredumps storage directory " + snapshotsStorageString + ", read&write permission required");
                }
                if (!Utils.prepareDirectory((File)coredumpsStorageDirectory)) {
                    throw new IllegalStateException("Cannot create coredumps storage directory " + snapshotsStorageString);
                }
            }
            return coredumpsStorageDirectory;
        }
    }

    public static boolean storageDirectoryExists() {
        return new File(CoreDumpSupport.getStorageDirectoryString()).isDirectory();
    }

    static void register() {
        DataSourceDescriptorFactory.getDefault().registerProvider((ModelProvider)new CoreDumpDescriptorProvider());
        CoreDumpsContainer.sharedInstance();
        CoreDumpProvider.register();
        RegisteredSnapshotCategories.sharedInstance().registerCategory((SnapshotCategory)category);
        DataSourceViewsManager.sharedInstance().addViewProvider((DataSourceViewProvider)viewProvider, CoreDump.class);
    }

    static {
        coredumpsStorageDirectoryStringLock = new Object();
        viewProvider = new CoreDumpOverviewViewProvider();
        category = new CoreDumpCategory();
        currentJDKHomeLock = new Object();
    }
}

