/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.swing.GenericToolbar;
import org.openide.util.Lookup;

public abstract class ProfilerToolbar {
    public static ProfilerToolbar create(boolean bl) {
        Provider provider = (Provider)Lookup.getDefault().lookup(Provider.class);
        return provider != null ? provider.create(bl) : new Impl(bl);
    }

    public abstract JComponent getComponent();

    public Component add(ProfilerToolbar profilerToolbar) {
        return profilerToolbar.getComponent();
    }

    public Component add(ProfilerToolbar profilerToolbar, int n) {
        return profilerToolbar.getComponent();
    }

    public void remove(ProfilerToolbar profilerToolbar) {
    }

    public abstract Component add(Action var1);

    public abstract Component add(Component var1);

    public abstract Component add(Component var1, int var2);

    public abstract void addSeparator();

    public abstract void addSpace(int var1);

    public abstract void addFiller();

    public abstract void remove(Component var1);

    public abstract void remove(int var1);

    public abstract int getComponentCount();

    protected ProfilerToolbar() {
    }

    public static class SimpleFocusTraversalPolicy
    extends FocusTraversalPolicy {
        @Override
        public Component getComponentAfter(Container container, Component component) {
            List<Component> list = this.components(this.topContainer(container));
            int n = list.indexOf(component);
            return n == -1 || n == list.size() - 1 ? null : list.get(n + 1);
        }

        @Override
        public Component getComponentBefore(Container container, Component component) {
            List<Component> list = this.components(this.topContainer(container));
            int n = list.indexOf(component);
            return n == -1 || n == 0 ? null : list.get(n - 1);
        }

        @Override
        public Component getFirstComponent(Container container) {
            List<Component> list = this.components(this.topContainer(container));
            return list.isEmpty() ? null : list.get(0);
        }

        @Override
        public Component getLastComponent(Container container) {
            List<Component> list = this.components(this.topContainer(container));
            return list.isEmpty() ? null : list.get(list.size() - 1);
        }

        @Override
        public Component getDefaultComponent(Container container) {
            return this.getFirstComponent(container);
        }

        protected Container topContainer(Container container) {
            while (container.getParent() instanceof JToolBar) {
                container = container.getParent();
            }
            return container;
        }

        protected List<Component> components(Container container) {
            ArrayList<Component> arrayList = new ArrayList<Component>();
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Component component = container.getComponent(i);
                if (component instanceof JToolBar || component instanceof JPanel) {
                    arrayList.addAll(this.components((Container)component));
                    continue;
                }
                if (!this.focusable(component)) continue;
                arrayList.add(component);
            }
            return arrayList;
        }

        protected boolean focusable(Component component) {
            return component.isVisible() && component.isEnabled() && component.isFocusable();
        }
    }

    public static class Impl
    extends ProfilerToolbar {
        protected final JComponent component;
        protected final JToolBar toolbar = new GenericToolbar();

        protected Impl(boolean bl) {
            if (UIUtils.isWindowsModernLookAndFeel()) {
                this.toolbar.setBorder(BorderFactory.createEmptyBorder(2, 2, 1, 2));
            } else if (!UIUtils.isNimbusLookAndFeel() && !UIUtils.isAquaLookAndFeel()) {
                this.toolbar.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
            }
            this.toolbar.setBorderPainted(false);
            this.toolbar.setRollover(true);
            this.toolbar.setFloatable(false);
            this.toolbar.setFocusTraversalPolicyProvider(true);
            this.toolbar.setFocusTraversalPolicy(new SimpleFocusTraversalPolicy());
            if (bl) {
                this.component = new JPanel(new BorderLayout(0, 0));
                this.component.setOpaque(false);
                this.component.add((Component)this.toolbar, "Center");
                this.component.add((Component)UIUtils.createHorizontalLine(this.toolbar.getBackground()), "South");
            } else {
                this.component = this.toolbar;
            }
        }

        @Override
        public JComponent getComponent() {
            return this.component;
        }

        @Override
        public Component add(ProfilerToolbar profilerToolbar) {
            return this.add(profilerToolbar, this.getComponentCount());
        }

        @Override
        public Component add(ProfilerToolbar profilerToolbar, int n) {
            JToolBar jToolBar = ((Impl)profilerToolbar).toolbar;
            jToolBar.setBorder(BorderFactory.createEmptyBorder());
            jToolBar.setOpaque(false);
            jToolBar.putClientProperty("Toolbar.noGTKBorder", Boolean.TRUE);
            return this.add(jToolBar, n);
        }

        @Override
        public void remove(ProfilerToolbar profilerToolbar) {
            this.remove(((Impl)profilerToolbar).toolbar);
        }

        @Override
        public Component add(Action action) {
            JButton jButton = this.toolbar.add(action);
            this.tweakComponent(jButton);
            this.toolbar.repaint();
            return jButton;
        }

        @Override
        public Component add(Component component) {
            Component component2 = this.toolbar.add(component);
            this.tweakComponent(component2);
            this.toolbar.repaint();
            return component2;
        }

        @Override
        public Component add(Component component, int n) {
            Component component2 = this.toolbar.add(component, n);
            this.tweakComponent(component2);
            this.toolbar.repaint();
            return component2;
        }

        @Override
        public void addSeparator() {
            this.toolbar.addSeparator();
            this.toolbar.repaint();
        }

        @Override
        public void addSpace(int n) {
            this.toolbar.addSeparator(new Dimension(n, 0));
            this.toolbar.repaint();
        }

        @Override
        public void addFiller() {
            Dimension dimension = new Dimension(0, 0);
            Dimension dimension2 = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
            this.toolbar.add(new Box.Filler(dimension, dimension, dimension2));
            this.toolbar.repaint();
        }

        @Override
        public void remove(Component component) {
            this.toolbar.remove(component);
            this.toolbar.repaint();
        }

        @Override
        public void remove(int n) {
            this.toolbar.remove(n);
            this.toolbar.repaint();
        }

        @Override
        public int getComponentCount() {
            return this.toolbar.getComponentCount();
        }

        private void tweakComponent(Component component) {
            if (component instanceof JComponent) {
                ((JComponent)component).setOpaque(false);
            }
        }
    }

    public static abstract class Provider {
        public abstract ProfilerToolbar create(boolean var1);
    }
}

