/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.heapviewer.java.impl;

import com.sun.tools.visualvm.core.ui.components.ScrollableContainer;
import com.sun.tools.visualvm.heapviewer.HeapContext;
import com.sun.tools.visualvm.heapviewer.java.InstanceNode;
import com.sun.tools.visualvm.heapviewer.java.InstanceNodeRenderer;
import com.sun.tools.visualvm.heapviewer.java.JavaHeapFragment;
import com.sun.tools.visualvm.heapviewer.java.impl.Bundle;
import com.sun.tools.visualvm.heapviewer.ui.HeapViewerActions;
import com.sun.tools.visualvm.heapviewer.ui.HeapViewerFeature;
import com.sun.tools.visualvm.heapviewer.ui.HeapViewerNodeAction;
import com.sun.tools.visualvm.heapviewer.utils.HeapUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.ItemEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.swing.GrayLabel;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.heapwalk.details.api.DetailsSupport;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsProvider;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsUtils;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

class JavaWindowsView
extends HeapViewerFeature {
    private static final String FEATURE_ID = "java_windows";
    private final HeapContext context;
    private final HeapViewerActions actions;
    private final Collection<HeapViewerNodeAction.Provider> actionProviders;
    private JComponent component;
    private ProfilerToolbar toolbar;
    private int height;
    private double scale;
    private final int estWindowCount;

    JavaWindowsView(HeapContext context, HeapViewerActions actions, int estWindowCount) {
        super(FEATURE_ID, Bundle.JavaWindowsView_Name(), Bundle.JavaWindowsView_Description(), Icons.getIcon((String)"HeapWalkerIcons.Window"), 400);
        this.context = context;
        this.actions = actions;
        this.estWindowCount = estWindowCount;
        this.actionProviders = new ArrayList<HeapViewerNodeAction.Provider>();
        for (HeapViewerNodeAction.Provider provider : Lookup.getDefault().lookupAll(HeapViewerNodeAction.Provider.class)) {
            if (!provider.supportsView(context, FEATURE_ID)) continue;
            this.actionProviders.add(provider);
        }
    }

    @Override
    public JComponent getComponent() {
        if (this.component == null) {
            this.init();
        }
        return this.component;
    }

    @Override
    public ProfilerToolbar getToolbar() {
        if (this.toolbar == null) {
            this.init();
        }
        return this.toolbar;
    }

    private void init() {
        this.component = new JPanel(null);
        this.component.setLayout(new BorderLayout());
        this.component.setOpaque(false);
        JLabel progress = new JLabel(Bundle.JavaWindowsView_ComputingWindows(), 10);
        progress.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        final int labelHeight = progress.getPreferredSize().height;
        this.component.add((Component)progress, "North");
        this.toolbar = ProfilerToolbar.create((boolean)false);
        this.toolbar.addSpace(2);
        this.toolbar.addSeparator();
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)new GrayLabel(Bundle.JavaWindowsView_Preview()));
        this.toolbar.addSpace(3);
        final ButtonGroup sizes = new ButtonGroup();
        this.toolbar.add((Component)new JToggleButton(Bundle.JavaWindowsView_150px()){
            {
                super(x0);
                sizes.add(this);
                this.putClientProperty("JButton.buttonType", "segmented");
                this.putClientProperty("JButton.segmentPosition", "first");
                this.setToolTipText(Bundle.JavaWindowsView_Tooltip150px());
            }

            @Override
            protected void fireItemStateChanged(ItemEvent event) {
                if (this.isSelected()) {
                    JavaWindowsView.this.scale = -1.0;
                    JavaWindowsView.this.height = 150;
                    JavaWindowsView.this.computeWindows();
                }
            }
        });
        this.toolbar.add((Component)new JToggleButton(Bundle.JavaWindowsView_300px()){
            {
                super(x0);
                sizes.add(this);
                this.putClientProperty("JButton.buttonType", "segmented");
                this.putClientProperty("JButton.segmentPosition", "middle");
                this.setToolTipText(Bundle.JavaWindowsView_Tooltip300px());
            }

            @Override
            protected void fireItemStateChanged(ItemEvent event) {
                if (this.isSelected()) {
                    JavaWindowsView.this.scale = -1.0;
                    JavaWindowsView.this.height = 300;
                    JavaWindowsView.this.computeWindows();
                }
            }
        });
        this.toolbar.add((Component)new JToggleButton(Bundle.JavaWindowsView_600px()){
            {
                super(x0);
                sizes.add(this);
                this.putClientProperty("JButton.buttonType", "segmented");
                this.putClientProperty("JButton.segmentPosition", "middle");
                this.setToolTipText(Bundle.JavaWindowsView_Tooltip600px());
            }

            @Override
            protected void fireItemStateChanged(ItemEvent event) {
                if (this.isSelected()) {
                    JavaWindowsView.this.scale = -1.0;
                    JavaWindowsView.this.height = 600;
                    JavaWindowsView.this.computeWindows();
                }
            }
        });
        this.toolbar.add((Component)new JToggleButton(Bundle.JavaWindowsView_50pc()){
            {
                super(x0);
                sizes.add(this);
                this.putClientProperty("JButton.buttonType", "segmented");
                this.putClientProperty("JButton.segmentPosition", "middle");
                this.setToolTipText(Bundle.JavaWindowsView_Tooltip50pc());
            }

            @Override
            protected void fireItemStateChanged(ItemEvent event) {
                if (this.isSelected()) {
                    JavaWindowsView.this.scale = 0.5;
                    JavaWindowsView.this.height = -1;
                    JavaWindowsView.this.computeWindows();
                }
            }
        });
        this.toolbar.add((Component)new JToggleButton(Bundle.JavaWindowsView_100pc()){
            {
                super(x0);
                sizes.add(this);
                this.putClientProperty("JButton.buttonType", "segmented");
                this.putClientProperty("JButton.segmentPosition", "last");
                this.setToolTipText(Bundle.JavaWindowsView_Tooltip100pc());
            }

            @Override
            protected void fireItemStateChanged(ItemEvent event) {
                if (this.isSelected()) {
                    JavaWindowsView.this.scale = 1.0;
                    JavaWindowsView.this.height = -1;
                    JavaWindowsView.this.computeWindows();
                }
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Enumeration<AbstractButton> buttons = sizes.getElements();
                AbstractButton selected = buttons.nextElement();
                int height = JavaWindowsView.this.component.getHeight();
                int wcount = Math.min(JavaWindowsView.this.estWindowCount, 3);
                if (wcount * (labelHeight + 300) <= height) {
                    selected = buttons.nextElement();
                }
                if (wcount * (labelHeight + 600) <= height) {
                    selected = buttons.nextElement();
                }
                selected.setSelected(true);
            }
        });
    }

    private void computeWindows() {
        new RequestProcessor("Heap Windows Processor").post(new Runnable(){

            @Override
            public void run() {
                final Heap heap = JavaWindowsView.this.context.getFragment().getHeap();
                final ArrayList windows = new ArrayList();
                windows.addAll(JavaWindowsView.getVisibleFrames(heap));
                windows.addAll(JavaWindowsView.getVisibleDialogs(heap));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JPanel container = new JPanel(null){
                            {
                                this.setOpaque(true);
                                this.setBackground(UIUtils.getProfilerResultsBackground());
                            }

                            @Override
                            public Dimension getMinimumSize() {
                                return this.getPreferredSize();
                            }
                        };
                        container.setLayout(new BoxLayout(container, 3));
                        for (Instance window : windows) {
                            InstanceNode windowNode = new InstanceNode(window);
                            ActionsHandler handler = new ActionsHandler(windowNode);
                            WindowPresenter presenter = new WindowPresenter(windowNode, heap);
                            container.add(new MarginContainer(presenter, "West", 15, 10, 0, 10));
                            handler.install(presenter);
                            WindowPreview preview = new WindowPreview(window, heap, JavaWindowsView.this.scale, JavaWindowsView.this.height);
                            container.add(new MarginContainer(preview, "West", 10, 27, 30, 10));
                            handler.install(preview);
                            container.add(new MarginContainer(UIUtils.createHorizontalSeparator(), 0, 15, 0, 10));
                        }
                        container.remove(container.getComponentCount() - 1);
                        container.add(Box.createVerticalGlue());
                        JavaWindowsView.this.component.removeAll();
                        JavaWindowsView.this.component.add((Component)new ScrollableContainer((JComponent)container), "Center");
                        JavaWindowsView.this.component.invalidate();
                        JavaWindowsView.this.component.getParent().revalidate();
                        JavaWindowsView.this.component.repaint();
                    }
                });
            }
        });
    }

    private static Collection<Instance> getVisibleFrames(Heap heap) {
        Collection<JavaClass> framesC = HeapUtils.getSubclasses(heap, "java.awt.Frame");
        ArrayList<Instance> framesI = new ArrayList<Instance>();
        for (JavaClass frameC : framesC) {
            framesI.addAll(frameC.getInstances());
        }
        return JavaWindowsView.onlyVisible(framesI);
    }

    private static Collection<Instance> getVisibleDialogs(Heap heap) {
        Collection<JavaClass> dialogsC = HeapUtils.getSubclasses(heap, "java.awt.Dialog");
        ArrayList<Instance> dialogsI = new ArrayList<Instance>();
        for (JavaClass dialogC : dialogsC) {
            dialogsI.addAll(dialogC.getInstances());
        }
        return JavaWindowsView.onlyVisible(dialogsI);
    }

    private static Collection<Instance> onlyVisible(Collection<Instance> instances) {
        Iterator<Instance> framesIt = instances.iterator();
        while (framesIt.hasNext()) {
            if (DetailsUtils.getBooleanFieldValue((Instance)framesIt.next(), (String)"visible", (boolean)false)) continue;
            framesIt.remove();
        }
        return instances;
    }

    public static class Provider
    extends HeapViewerFeature.Provider {
        @Override
        public HeapViewerFeature getFeature(HeapContext context, HeapViewerActions actions) {
            if (!JavaHeapFragment.isJavaHeap(context)) {
                return null;
            }
            Heap heap = context.getFragment().getHeap();
            int estWindowsCount = JavaWindowsView.getVisibleFrames(heap).size();
            if (estWindowsCount <= 1) {
                estWindowsCount += JavaWindowsView.getVisibleDialogs(heap).size();
            }
            return estWindowsCount == 0 ? null : new JavaWindowsView(context, actions, estWindowsCount);
        }
    }

    private static class WindowPreview
    extends JPanel {
        private final Instance windowInstance;
        private final Heap heap;
        private final double scale;
        private final int prefHeight;
        private int realHeight;
        private int realWidth;
        private Image windowImage;

        WindowPreview(Instance windowInstance, Heap heap, double scale, int prefHeight) {
            super(new BorderLayout());
            this.setOpaque(false);
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.windowInstance = windowInstance;
            this.heap = heap;
            this.scale = scale;
            this.prefHeight = prefHeight;
            this.realHeight = prefHeight;
            this.realWidth = -1;
            this.createPreview();
        }

        @Override
        public void paint(Graphics g) {
            if (this.windowImage != null) {
                g.drawImage(this.windowImage, 0, 0, null);
            } else {
                super.paint(g);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            int width = this.realWidth == -1 ? super.getPreferredSize().width : this.realWidth;
            return new Dimension(width, this.realHeight);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(0, this.realHeight);
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, this.realHeight);
        }

        private void createPreview() {
            DetailsProvider.View windowComponent = DetailsSupport.getDetailsView((Instance)this.windowInstance, (Heap)this.heap);
            if (windowComponent != null) {
                Component progress = windowComponent.getComponent(0);
                windowComponent.addContainerListener(new ContainerListener((JComponent)windowComponent, progress){
                    private boolean progressRemoved = false;
                    final /* synthetic */ JComponent val$windowComponent;
                    final /* synthetic */ Component val$progress;
                    {
                        this.val$windowComponent = jComponent;
                        this.val$progress = component;
                    }

                    @Override
                    public void componentAdded(ContainerEvent e) {
                        if (this.progressRemoved && this.val$windowComponent.getComponentCount() == 2) {
                            this.val$windowComponent.removeContainerListener(this);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    double ratio;
                                    Component c = val$windowComponent.getComponent(1);
                                    c.setMinimumSize(c.getPreferredSize());
                                    c.invalidate();
                                    c.getParent().revalidate();
                                    c.doLayout();
                                    Dimension winSize = c.getSize();
                                    if (scale > 0.0 && scale < 1.0) {
                                        ratio = scale;
                                        realHeight = (int)(ratio * (double)winSize.height) + 1;
                                        realWidth = (int)(ratio * (double)winSize.width) + 1;
                                    } else if (scale >= 1.0 || winSize.height <= prefHeight) {
                                        ratio = 1.0;
                                        realHeight = winSize.height;
                                        realWidth = winSize.width;
                                    } else {
                                        ratio = (double)prefHeight / (double)winSize.height;
                                        realHeight = prefHeight;
                                        realWidth = (int)(ratio * (double)winSize.width) + 1;
                                    }
                                    windowImage = ratio == 1.0 ? this.createImage(realWidth, realHeight) : new BufferedImage(realWidth, realHeight, 2);
                                    Graphics g = windowImage.getGraphics();
                                    if (g instanceof Graphics2D) {
                                        Graphics2D g2 = (Graphics2D)g;
                                        g2.setTransform(AffineTransform.getScaleInstance(ratio, ratio));
                                        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                                    }
                                    c.paint(g);
                                    g.dispose();
                                    this.removeAll();
                                    this.repaint();
                                }
                            });
                        }
                    }

                    @Override
                    public void componentRemoved(ContainerEvent e) {
                        if (e.getChild() == this.val$progress) {
                            this.progressRemoved = true;
                        }
                    }
                });
                this.add((Component)windowComponent, "West");
            } else {
                JLabel noPreview = new JLabel(Bundle.JavaWindowsView_NoPreview(), 10);
                noPreview.setBorder(BorderFactory.createEmptyBorder(5, 20, 5, 20));
                noPreview.setEnabled(false);
                Dimension pref = noPreview.getPreferredSize();
                this.realWidth = pref.width;
                this.realHeight = pref.height;
                this.add((Component)noPreview, "Center");
            }
        }
    }

    private static class WindowPresenter
    extends JPanel {
        WindowPresenter(InstanceNode windowNode, Heap heap) {
            super(new BorderLayout());
            this.setOpaque(false);
            this.setCursor(Cursor.getPredefinedCursor(12));
            InstanceNodeRenderer renderer = new InstanceNodeRenderer(heap);
            renderer.setValue((Object)windowNode, -1);
            JComponent rendererC = renderer.getComponent();
            rendererC.setOpaque(false);
            this.add((Component)rendererC, "West");
        }
    }

    private static class MarginContainer
    extends JPanel {
        MarginContainer(Component comp, int top, int left, int bottom, int right) {
            this(comp, "Center", top, left, bottom, right);
        }

        MarginContainer(Component comp, Object position, int top, int left, int bottom, int right) {
            super(new BorderLayout());
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(top, left, bottom, right));
            this.add(comp, position);
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(super.getMaximumSize().width, super.getPreferredSize().height);
        }
    }

    private class ActionsHandler
    extends MouseAdapter {
        private final InstanceNode windowNode;

        ActionsHandler(InstanceNode windowNode) {
            this.windowNode = windowNode;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                this.handleClick(e);
            }
            if (SwingUtilities.isMiddleMouseButton(e)) {
                this.handleMiddleClick(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.handleShowPopup(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.handleShowPopup(e);
            }
        }

        void install(Component c) {
            c.addMouseListener(this);
        }

        private void handleClick(MouseEvent e) {
            HeapViewerNodeAction.Actions nodeActions = HeapViewerNodeAction.Actions.forNode(this.windowNode, JavaWindowsView.this.actionProviders, JavaWindowsView.this.context, JavaWindowsView.this.actions, new HeapViewerNodeAction[0]);
            ActionEvent ae = new ActionEvent(e.getSource(), e.getID(), "left button", e.getWhen(), e.getModifiers());
            nodeActions.performDefaultAction(ae);
        }

        private void handleMiddleClick(MouseEvent e) {
            HeapViewerNodeAction.Actions nodeActions = HeapViewerNodeAction.Actions.forNode(this.windowNode, JavaWindowsView.this.actionProviders, JavaWindowsView.this.context, JavaWindowsView.this.actions, new HeapViewerNodeAction[0]);
            ActionEvent ae = new ActionEvent(e.getSource(), e.getID(), "middle button", e.getWhen(), e.getModifiers());
            nodeActions.performMiddleButtonAction(ae);
        }

        private void handleShowPopup(MouseEvent e) {
            JPopupMenu popup = new JPopupMenu();
            HeapViewerNodeAction.Actions nodeActions = HeapViewerNodeAction.Actions.forNode(this.windowNode, JavaWindowsView.this.actionProviders, JavaWindowsView.this.context, JavaWindowsView.this.actions, new HeapViewerNodeAction[0]);
            nodeActions.populatePopup(popup);
            if (popup.getComponentCount() > 0) {
                popup.show((Component)e.getSource(), e.getX(), e.getY());
            }
        }
    }
}

