/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public final class MoveUpAction
extends NodeAction {
    private static final String PROP_ORDER_LISTENER = "sellistener";
    private static Logger err = Logger.getLogger("org.openide.actions.MoveUpAction");
    private Reference curIndexCookie;

    protected void initialize() {
        err.fine("initialize");
        super.initialize();
        OrderingListener orderingListener = new OrderingListener();
        this.putProperty(PROP_ORDER_LISTENER, orderingListener);
    }

    private Index getCurIndexCookie() {
        return this.curIndexCookie == null ? null : (Index)this.curIndexCookie.get();
    }

    protected void performAction(Node[] nodeArray) {
        Index index = this.getIndexCookie(nodeArray);
        if (index == null) {
            return;
        }
        int n = index.indexOf(nodeArray[0]);
        if (n > 0) {
            index.moveUp(n);
        }
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] nodeArray) {
        err.fine("enable; activatedNodes=" + (nodeArray == null ? null : Arrays.asList(nodeArray)));
        Index index = this.getCurIndexCookie();
        if (index != null) {
            index.removeChangeListener((ChangeListener)this.getProperty(PROP_ORDER_LISTENER));
        }
        Index index2 = this.getIndexCookie(nodeArray);
        if (err != null) {
            err.fine("enable; cookie=" + index2);
        }
        if (index2 == null) {
            return false;
        }
        index2.addChangeListener((ChangeListener)((OrderingListener)this.getProperty(PROP_ORDER_LISTENER)));
        this.curIndexCookie = new WeakReference<Index>(index2);
        int n = index2.indexOf(nodeArray[0]);
        if (err != null) {
            err.fine("enable; index=" + n);
            if (n == -1) {
                Node node = nodeArray[0].getParentNode();
                err.fine("enable; parent=" + node + "; parent.children=" + Arrays.asList(node.getChildren().getNodes()));
            }
        }
        return n > 0;
    }

    public String getName() {
        return NbBundle.getMessage(MoveUpAction.class, (String)"MoveUp");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(MoveUpAction.class);
    }

    private Index getIndexCookie(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length != 1) {
            return null;
        }
        Node node = nodeArray[0].getParentNode();
        if (node == null) {
            return null;
        }
        return (Index)node.getCookie(Index.class);
    }

    private final class OrderingListener
    implements ChangeListener {
        OrderingListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Node[] nodeArray = MoveUpAction.this.getActivatedNodes();
            err.fine("stateChanged; activatedNodes=" + (nodeArray == null ? null : Arrays.asList(nodeArray)));
            Index index = MoveUpAction.this.getIndexCookie(nodeArray);
            if (err != null) {
                err.fine("stateChanged; cookie=" + index);
            }
            if (index == null) {
                MoveUpAction.this.setEnabled(false);
            } else {
                int n = index.indexOf(nodeArray[0]);
                if (err != null) {
                    err.fine("stateChanged; index=" + n);
                }
                MoveUpAction.this.setEnabled(n > 0);
            }
        }
    }
}

