/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.uisupport;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.Box;

public final class VerticalLayout
implements LayoutManager {
    private final boolean proportionalWidth;
    private final int vGap;

    public VerticalLayout(boolean proportionalWidth) {
        this(proportionalWidth, 0);
    }

    public VerticalLayout(boolean proportionalWidth, int vGap) {
        this.proportionalWidth = proportionalWidth;
        this.vGap = vGap;
    }

    @Override
    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        int posX = insets.left;
        int posY = insets.top;
        int width = parent.getWidth() - insets.left - insets.right;
        for (Component comp : parent.getComponents()) {
            if (!comp.isVisible()) continue;
            Dimension pref = comp.getPreferredSize();
            if (this.proportionalWidth) {
                int w = Math.min(pref.width, width);
                int o = (width - w) / 2;
                comp.setBounds(posX, posY + o, w, pref.height);
            } else {
                comp.setBounds(posX, posY, width, pref.height);
            }
            pref.height += this.vGap;
            posY += pref.height;
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        Dimension d = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        int maxWidth = 0;
        int visibleCount = 0;
        for (Component comp : parent.getComponents()) {
            if (!comp.isVisible() || comp instanceof Box.Filler) continue;
            Dimension size = comp.getPreferredSize();
            maxWidth = Math.max(maxWidth, size.width);
            d.height += size.height;
            ++visibleCount;
        }
        d.height += (visibleCount - 1) * this.vGap;
        d.width += maxWidth;
        return d;
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        Dimension d = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        int maxWidth = 0;
        int visibleCount = 0;
        for (Component comp : parent.getComponents()) {
            if (!comp.isVisible()) continue;
            Dimension size = comp.getPreferredSize();
            maxWidth = Math.max(maxWidth, size.width);
            d.height += size.height;
            ++visibleCount;
        }
        d.height += (visibleCount - 1) * this.vGap;
        d.width += maxWidth;
        return d;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }
}

