#!/usr/bin/env perl
# BEGIN COPYRIGHT BLOCK
# Copyright (C) 2007 Red Hat, Inc.
# All rights reserved.
#
# License: GPL (version 3 or any later version).
# See LICENSE for details. 
# END COPYRIGHT BLOCK
#

###########################
#
# This perl module provides a way to set up a new installation after
# the binaries have already been extracted.  This is typically after
# using native packaging support to install the package e.g. RPM,
# pkgadd, depot, etc.  This script will show the license, readme,
# dsktune, then run the usual setup pre and post installers.
#
##########################

use lib qw(/usr/lib/dirsrv/perl);

use strict;

use DSMigration;
use Migration;
use Resource;

my $res = new Resource("/usr/share/dirsrv/properties/migrate-ds.res",
                       "/usr/share/dirsrv/properties/setup-ds.res");

my $mig = new Migration($res);

$mig->msg('begin_ds_migration', $mig->{oldsroot});
if (!migrateDS($mig)) {
    $mig->doExit(1);
}
$mig->msg('end_ds_migration');
$mig->doExit(0);

END {
    if ($mig and $mig->{keep}) {
        $mig->{inf}->write("__temp__");
    }
}

# emacs settings
# Local Variables:
# mode:perl
# indent-tabs-mode: nil
# tab-width: 4
# End:
