/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.info;

import jadx.api.IJadxArgs;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.instructions.args.LiteralArg;
import jadx.core.dex.instructions.args.PrimitiveType;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.DexNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.ResRefField;
import jadx.core.dex.nodes.parser.FieldInitAttr;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class ConstStorage {
    private final boolean replaceEnabled;
    private final Values globalValues = new Values();
    private final Map<ClassNode, Values> classes = new HashMap<ClassNode, Values>();
    private Map<Integer, String> resourcesNames = new HashMap<Integer, String>();

    public ConstStorage(IJadxArgs args) {
        this.replaceEnabled = args.isReplaceConsts();
    }

    public void processConstFields(ClassNode cls, List<FieldNode> staticFields) {
        if (!this.replaceEnabled || staticFields.isEmpty()) {
            return;
        }
        for (FieldNode f : staticFields) {
            FieldInitAttr fv;
            AccessInfo accFlags = f.getAccessFlags();
            if (!accFlags.isStatic() || !accFlags.isFinal() || (fv = f.get(AType.FIELD_INIT)) == null || fv.getValue() == null || fv.getValueType() != FieldInitAttr.InitType.CONST || fv == FieldInitAttr.NULL_VALUE) continue;
            this.addConstField(cls, f, fv.getValue(), accFlags.isPublic());
        }
    }

    private void addConstField(ClassNode cls, FieldNode fld, Object value, boolean isPublic) {
        if (isPublic) {
            this.globalValues.put(value, fld);
        } else {
            this.getClsValues(cls).put(value, fld);
        }
    }

    private Values getClsValues(ClassNode cls) {
        Values classValues = this.classes.get(cls);
        if (classValues == null) {
            classValues = new Values();
            this.classes.put(cls, classValues);
        }
        return classValues;
    }

    @Nullable
    public FieldNode getConstField(ClassNode cls, Object value, boolean searchGlobal) {
        String str;
        DexNode dex = cls.dex();
        if (value instanceof Integer && (str = this.resourcesNames.get(value)) != null) {
            return new ResRefField(dex, str.replace('/', '.'));
        }
        if (!this.replaceEnabled) {
            return null;
        }
        boolean foundInGlobal = this.globalValues.contains(value);
        if (foundInGlobal && !searchGlobal) {
            return null;
        }
        ClassNode current = cls;
        while (current != null) {
            FieldNode field;
            Values classValues = this.classes.get(current);
            if (classValues != null && (field = classValues.get(value)) != null) {
                if (foundInGlobal) {
                    return null;
                }
                return field;
            }
            ClassInfo parentClass = current.getClassInfo().getParentClass();
            if (parentClass == null) break;
            current = dex.resolveClass(parentClass);
        }
        if (searchGlobal) {
            return this.globalValues.get(value);
        }
        return null;
    }

    @Nullable
    public FieldNode getConstFieldByLiteralArg(ClassNode cls, LiteralArg arg) {
        PrimitiveType type = arg.getType().getPrimitiveType();
        if (type == null) {
            return null;
        }
        long literal = arg.getLiteral();
        switch (type) {
            case BOOLEAN: {
                return this.getConstField(cls, literal == 1L, false);
            }
            case CHAR: {
                return this.getConstField(cls, Character.valueOf((char)literal), Math.abs(literal) > 10L);
            }
            case BYTE: {
                return this.getConstField(cls, (byte)literal, Math.abs(literal) > 10L);
            }
            case SHORT: {
                return this.getConstField(cls, (short)literal, Math.abs(literal) > 100L);
            }
            case INT: {
                return this.getConstField(cls, (int)literal, Math.abs(literal) > 100L);
            }
            case LONG: {
                return this.getConstField(cls, literal, Math.abs(literal) > 1000L);
            }
            case FLOAT: {
                float f = Float.intBitsToFloat((int)literal);
                return this.getConstField(cls, Float.valueOf(f), (double)f != 0.0);
            }
            case DOUBLE: {
                double d = Double.longBitsToDouble(literal);
                return this.getConstField(cls, d, d != 0.0);
            }
        }
        return null;
    }

    public void setResourcesNames(Map<Integer, String> resourcesNames) {
        this.resourcesNames = resourcesNames;
    }

    public Map<Integer, String> getResourcesNames() {
        return this.resourcesNames;
    }

    public Map<Object, FieldNode> getGlobalConstFields() {
        return this.globalValues.getValues();
    }

    public boolean isReplaceEnabled() {
        return this.replaceEnabled;
    }

    private static final class Values {
        private final Map<Object, FieldNode> values = new HashMap<Object, FieldNode>();
        private final Set<Object> duplicates = new HashSet<Object>();

        private Values() {
        }

        public Map<Object, FieldNode> getValues() {
            return this.values;
        }

        public FieldNode get(Object key) {
            return this.values.get(key);
        }

        public boolean put(Object value, FieldNode fld) {
            FieldNode prev = this.values.put(value, fld);
            if (prev != null) {
                this.values.remove(value);
                this.duplicates.add(value);
                return true;
            }
            if (this.duplicates.contains(value)) {
                this.values.remove(value);
                return true;
            }
            return false;
        }

        public boolean contains(Object value) {
            return this.duplicates.contains(value) || this.values.containsKey(value);
        }
    }
}

