/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import java.io.File;
import java.io.IOException;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.classdiagram.command.JavaClass;
import net.sourceforge.plantuml.classdiagram.command.JavaFile;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;

public class CommandImport
extends SingleLineCommand2<ClassDiagram> {
    public CommandImport() {
        super(CommandImport.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandImport.class.getName(), RegexLeaf.start(), new RegexLeaf("import"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("[%g]?"), new RegexLeaf("NAME", "([^%g]+)"), new RegexLeaf("[%g]?"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(ClassDiagram diagram, LineLocation location, RegexResult arg) {
        String arg0 = arg.get("NAME", 0);
        try {
            File f = FileSystem.getInstance().getFile(arg0);
            if (f.isFile()) {
                this.includeSimpleFile(diagram, f);
            } else if (f.isDirectory()) {
                this.includeDirectory(diagram, f);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return CommandExecutionResult.error("IO error " + e);
        }
        return CommandExecutionResult.ok();
    }

    private void includeDirectory(ClassDiagram classDiagram, File dir) throws IOException {
        for (File f : dir.listFiles()) {
            this.includeSimpleFile(classDiagram, f);
        }
    }

    private void includeSimpleFile(ClassDiagram classDiagram, File f) throws IOException {
        if (StringUtils.goLowerCase(f.getName()).endsWith(".java")) {
            this.includeFileJava(classDiagram, f);
        }
    }

    private void includeFileJava(ClassDiagram diagram, File f) throws IOException {
        JavaFile javaFile = new JavaFile(f);
        for (JavaClass cl : javaFile.getJavaClasses()) {
            String idShort = cl.getName();
            Code name = diagram.buildCode(idShort);
            ILeaf ent1 = diagram.getOrCreateLeaf(diagram.buildLeafIdent(idShort), name, cl.getType(), null);
            for (String p : cl.getParents()) {
                ILeaf ent2 = diagram.getOrCreateLeaf(diagram.buildLeafIdent(p), diagram.buildCode(p), cl.getParentType(), null);
                Link link = new Link(ent2, ent1, new LinkType(LinkDecor.NONE, LinkDecor.EXTENDS), Display.NULL, 2, diagram.getSkinParam().getCurrentStyleBuilder());
                diagram.addLink(link);
            }
        }
    }
}

