/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.InlinedLineNumberInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.NoOperandInstr;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.ir.transformations.inlining.InlineCloneInfo;

public class LineNumberInstr
extends NoOperandInstr
implements FixedArityInstr {
    public final int lineNumber;

    public LineNumberInstr(int lineNumber) {
        super(Operation.LINE_NUM);
        this.lineNumber = lineNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"n: " + this.lineNumber};
    }

    @Override
    public Instr clone(CloneInfo ii) {
        if (ii instanceof InlineCloneInfo) {
            new InlinedLineNumberInstr(((InlineCloneInfo)ii).getScopeBeingInlined(), this.lineNumber);
        }
        return this;
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getLineNumber());
    }

    public static LineNumberInstr decode(IRReaderDecoder d) {
        return d.getCurrentScope().getManager().newLineNumber(d.decodeInt());
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.LineNumberInstr(this);
    }
}

