/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.passes;

import java.util.Set;
import org.jruby.ir.IRScope;
import org.jruby.ir.dataflow.analyses.DefinedVariablesProblem;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Nil;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.passes.CompilerPass;
import org.jruby.ir.representations.BasicBlock;

public class AddMissingInitsPass
extends CompilerPass {
    @Override
    public String getLabel() {
        return "Add Missing Initialization";
    }

    @Override
    public String getShortLabel() {
        return "Add Missing Init.";
    }

    @Override
    public Object execute(IRScope scope, Object ... data2) {
        scope.computeScopeFlags();
        DefinedVariablesProblem p2 = new DefinedVariablesProblem(scope);
        p2.compute_MOP_Solution();
        Set<Variable> undefinedVars = p2.findUndefinedVars();
        BasicBlock bb = scope.getCFG().getEntryBB();
        for (Variable v : undefinedVars) {
            if (v instanceof LocalVariable) {
                bb.getInstrs().add(new CopyInstr(v, new Nil()));
                continue;
            }
            bb.getInstrs().add(0, new CopyInstr(v, new Nil()));
        }
        return null;
    }
}

