/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.EntropySource;
import org.bouncycastle.crypto.EntropySourceProvider;

class FixedEntropySourceProvider
implements EntropySourceProvider {
    private final byte[] data;
    private final boolean isPredictionResistant;

    protected FixedEntropySourceProvider(byte[] byArray, boolean bl) {
        this.data = byArray;
        this.isPredictionResistant = bl;
    }

    public EntropySource get(final int n) {
        return new EntropySource(){
            int index = 0;

            public boolean isPredictionResistant() {
                return FixedEntropySourceProvider.this.isPredictionResistant;
            }

            public byte[] getEntropy() {
                byte[] byArray = new byte[(n + 7) / 8];
                System.arraycopy(FixedEntropySourceProvider.this.data, this.index, byArray, 0, byArray.length);
                this.index += (n + 7) / 8;
                return byArray;
            }

            public int entropySize() {
                return n;
            }
        };
    }
}

