/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ChoiceItem;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Unit;

public final class CaptureGoodsDialog
extends FreeColDialog<List<Goods>> {
    private static final Logger logger = Logger.getLogger(CaptureGoodsDialog.class.getName());
    private final int maxCargo;
    private final JButton allButton;
    private final JButton noneButton;
    private final JList<GoodsItem> goodsList;

    public CaptureGoodsDialog(FreeColClient freeColClient, JFrame frame, Unit winner, List<Goods> loot) {
        super(freeColClient, frame);
        this.maxCargo = winner.getSpaceLeft();
        this.allButton = Utility.localizedButton("all");
        this.allButton.addActionListener(ae -> {
            JList<GoodsItem> gl = this.goodsList;
            for (int i = 0; i < gl.getModel().getSize() && i < this.maxCargo; ++i) {
                GoodsItem gi = gl.getModel().getElementAt(i);
                gi.setSelected(true);
                this.updateComponents();
            }
        });
        this.allButton.setMnemonic('a');
        this.allButton.setActionCommand(this.allButton.getText());
        this.noneButton = Utility.localizedButton("none");
        this.noneButton.addActionListener(ae -> {
            JList<GoodsItem> gl = this.goodsList;
            for (int i = 0; i < gl.getModel().getSize(); ++i) {
                GoodsItem gi = gl.getModel().getElementAt(i);
                gi.setSelected(false);
                this.updateComponents();
            }
        });
        this.noneButton.setMnemonic('n');
        this.noneButton.setActionCommand(this.noneButton.getText());
        GoodsItem[] goods = new GoodsItem[loot.size()];
        for (int i = 0; i < loot.size(); ++i) {
            goods[i] = new GoodsItem(loot.get(i));
        }
        this.goodsList = new JList();
        this.goodsList.setListData((GoodsItem[])goods);
        this.goodsList.setCellRenderer(new CheckBoxRenderer());
        this.goodsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                JList gl = CaptureGoodsDialog.this.goodsList;
                int index = gl.locationToIndex(me.getPoint());
                if (index < 0) {
                    return;
                }
                GoodsItem item = (GoodsItem)gl.getModel().getElementAt(index);
                if (item.isEnabled()) {
                    item.setSelected(!item.isSelected());
                }
                CaptureGoodsDialog.this.updateComponents();
            }
        });
        MigPanel panel = new MigPanel(new MigLayout("wrap 1", "[center]", "[]20[]20[]"));
        panel.add(Utility.localizedHeader("captureGoodsDialog.title", true));
        panel.add((Component)this.allButton, "split 2");
        panel.add(this.noneButton);
        panel.add(this.goodsList);
        panel.setSize(panel.getPreferredSize());
        Object fake = null;
        List c = CaptureGoodsDialog.choices();
        c.add(new ChoiceItem<Object>(Messages.message("ok"), fake).okOption().defaultOption());
        this.initializeDialog(frame, FreeColDialog.DialogType.QUESTION, false, panel, new ImageIcon(this.getImageLibrary().getUnitImage(winner)), c);
    }

    private void updateComponents() {
        GoodsItem gi;
        int i;
        int selectedCount = 0;
        for (i = 0; i < this.goodsList.getModel().getSize(); ++i) {
            gi = this.goodsList.getModel().getElementAt(i);
            if (!gi.isSelected()) continue;
            ++selectedCount;
        }
        if (selectedCount >= this.maxCargo) {
            this.allButton.setEnabled(false);
            for (i = 0; i < this.goodsList.getModel().getSize(); ++i) {
                gi = this.goodsList.getModel().getElementAt(i);
                if (gi.isSelected()) continue;
                gi.setEnabled(false);
            }
        } else {
            this.allButton.setEnabled(true);
            for (i = 0; i < this.goodsList.getModel().getSize(); ++i) {
                gi = this.goodsList.getModel().getElementAt(i);
                if (gi.isSelected()) continue;
                gi.setEnabled(true);
            }
        }
        this.goodsList.repaint();
    }

    @Override
    public List<Goods> getResponse() {
        Object value = this.getValue();
        ArrayList<Goods> gl = new ArrayList<Goods>();
        if (((ChoiceItem)this.options.get(0)).equals(value)) {
            for (int i = 0; i < this.goodsList.getModel().getSize(); ++i) {
                GoodsItem gi = this.goodsList.getModel().getElementAt(i);
                if (!gi.isSelected()) continue;
                gl.add(gi.getGoods());
            }
        }
        return gl;
    }

    private static class CheckBoxRenderer
    extends JCheckBox
    implements ListCellRenderer<GoodsItem> {
        @Override
        public Component getListCellRendererComponent(JList<? extends GoodsItem> list, GoodsItem value, int index, boolean isSelected, boolean hasFocus) {
            this.setSelected(value.isSelected());
            this.setText(value.toString());
            this.setEnabled(value.isEnabled());
            return this;
        }
    }

    private static class GoodsItem
    extends JCheckBox {
        private final Goods goods;

        public GoodsItem(Goods goods) {
            this.goods = goods;
        }

        public Goods getGoods() {
            return this.goods;
        }

        @Override
        public String toString() {
            return Messages.message(this.goods.getLabel());
        }
    }
}

