/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common;

import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pushingpixels.flamingo.internal.ui.common.BasicScrollablePanelUI;
import org.pushingpixels.flamingo.internal.ui.common.ScrollablePanelUI;

public class JScrollablePanel<T extends JComponent>
extends JPanel {
    public static final String uiClassID = "ScrollablePanelUI";
    private T view;
    private ScrollType scrollType;
    private boolean isScrollOnRollover;

    public JScrollablePanel(T c, ScrollType scrollType) {
        this.view = c;
        this.scrollType = scrollType;
        this.isScrollOnRollover = true;
        this.updateUI();
    }

    @Override
    public ScrollablePanelUI getUI() {
        return (ScrollablePanelUI)this.ui;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((ScrollablePanelUI)UIManager.getUI(this));
        } else {
            this.setUI(BasicScrollablePanelUI.createUI(this));
        }
    }

    public void setScrollOnRollover(boolean toScrollOnRollover) {
        boolean old = this.isScrollOnRollover;
        this.isScrollOnRollover = toScrollOnRollover;
        if (old != this.isScrollOnRollover) {
            this.firePropertyChange("scrollOnRollover", old, this.isScrollOnRollover);
        }
    }

    public void scrollToIfNecessary(int startPosition, int span) {
        this.getUI().scrollToIfNecessary(startPosition, span);
    }

    public T getView() {
        return this.view;
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(changeEvent);
        }
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.fireStateChanged();
    }

    public ScrollType getScrollType() {
        return this.scrollType;
    }

    public boolean isScrollOnRollover() {
        return this.isScrollOnRollover;
    }

    public boolean isShowingScrollButtons() {
        return this.getUI().isShowingScrollButtons();
    }

    public static enum ScrollType {
        VERTICALLY,
        HORIZONTALLY;

    }
}

