/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.io.PrintStream;
import org.jmol.util.Logger;
import org.jmol.util.LoggerInterface;

public class DefaultLogger
implements LoggerInterface {
    protected void log(PrintStream printStream, int n, String string, Throwable throwable) {
        if (printStream == System.err) {
            System.out.flush();
        }
        if (printStream != null && (string != null || throwable != null)) {
            StackTraceElement[] stackTraceElementArray;
            string = string != null ? string : "";
            printStream.println(String.valueOf(Logger.logLevel() ? "[" + Logger.getLevel(n) + "] " : "") + string + (throwable != null ? ": " + throwable.toString() : ""));
            if (throwable != null && (stackTraceElementArray = throwable.getStackTrace()) != null) {
                int n2 = 0;
                while (n2 < stackTraceElementArray.length) {
                    printStream.println(String.valueOf(stackTraceElementArray[n2].getClassName()) + " - " + stackTraceElementArray[n2].getLineNumber() + " - " + stackTraceElementArray[n2].getMethodName());
                    ++n2;
                }
            }
        }
        if (printStream == System.err) {
            System.err.flush();
        }
    }

    @Override
    public void debug(String string) {
        this.log(System.out, 5, string, null);
    }

    @Override
    public void info(String string) {
        this.log(System.out, 4, string, null);
    }

    @Override
    public void warn(String string) {
        this.log(System.out, 3, string, null);
    }

    @Override
    public void warnEx(String string, Throwable throwable) {
        this.log(System.out, 3, string, throwable);
    }

    @Override
    public void error(String string) {
        this.log(System.err, 2, string, null);
    }

    @Override
    public void errorEx(String string, Throwable throwable) {
        this.log(System.err, 2, string, throwable);
    }

    @Override
    public void fatal(String string) {
        this.log(System.err, 1, string, null);
    }

    @Override
    public void fatalEx(String string, Throwable throwable) {
        this.log(System.err, 1, string, throwable);
    }
}

