/*
 * Decompiled with CFR 0.152.
 */
package jspecview.export;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.OC;
import javajs.util.PT;
import jspecview.common.Coordinate;
import org.jmol.util.Logger;

class FormContext {
    String[] tokens;
    Hashtable<String, Object> context = new Hashtable();
    Lst<FormToken> formTokens;
    int commandLevel;
    Lst<Integer> cmds = new Lst();
    String strError;
    static final int VT_DATA = 0;
    static final int VT_IF = 1;
    static final int VT_ELSE = 2;
    static final int VT_ELSEIF = 3;
    static final int VT_END = 4;
    static final int VT_FOREACH = 5;
    static final int VT_SET = 6;
    private static final String[] ops = new String[]{"==", "!=", "="};
    private static final int OP_EEQ = 0;
    private static final int OP_NE = 1;
    private static final int OP_EQ = 2;

    FormContext() {
    }

    void put(String key, Object value) {
        if (value == null) {
            value = "";
        }
        this.context.put(key, value);
    }

    String setTemplate(String template) {
        String errMsg = this.getFormTokens(template);
        if (errMsg != null) {
            return errMsg;
        }
        return null;
    }

    private String getFormTokens(String template) {
        this.formTokens = new Lst();
        if (template.indexOf("\r\n") >= 0) {
            template = PT.replaceAllCharacters(template, "\r\n", "\n");
        }
        template = template.replace('\r', '\n');
        String[] lines = template.split("\n");
        String token = "";
        for (int i = 0; i < lines.length && this.strError == null; ++i) {
            char ch;
            String line = lines[i];
            int m = line.length();
            while (--m >= 0 && ((ch = line.charAt(m)) == ' ' || ch == '\t')) {
            }
            if ((line = line.substring(0, m + 1)).length() == 0) continue;
            int firstChar = -1;
            int nChar = line.length();
            while (++firstChar < nChar && Character.isWhitespace(line.charAt(firstChar))) {
            }
            if (line.indexOf("#") == firstChar) {
                if (token.length() > 0) {
                    new FormToken(token, 0);
                    token = "";
                }
                if (this.strError != null) break;
                new FormToken(line, firstChar);
                continue;
            }
            token = token + line + "\n";
        }
        if (token.length() > 0 && this.strError == null) {
            new FormToken(token, 0);
        }
        return this.strError;
    }

    public String merge(OC out) {
        block7: for (int i = 0; i < this.formTokens.size() && this.strError == null; ++i) {
            FormToken vt = (FormToken)this.formTokens.get(i);
            switch (vt.cmdType) {
                case 0: {
                    String data = this.fillData(vt.data);
                    out.append(data);
                    continue block7;
                }
                case 1: {
                    if (this.evaluate(vt.data, true)) {
                        vt.endPtr = -vt.endPtr;
                        continue block7;
                    }
                    i = vt.endPtr - 1;
                    continue block7;
                }
                case 2: 
                case 3: {
                    int ptr = ((FormToken)this.formTokens.get((int)vt.cmdPtr)).endPtr;
                    if (ptr < 0) {
                        ((FormToken)this.formTokens.get((int)vt.cmdPtr)).endPtr = -ptr;
                        do {
                            vt = (FormToken)this.formTokens.get(vt.endPtr);
                        } while (vt.cmdType != 4);
                        i = vt.ptr;
                        continue block7;
                    }
                    if (vt.cmdType != 3) continue block7;
                    if (this.evaluate(vt.data, true)) {
                        vt.endPtr = -vt.endPtr;
                        continue block7;
                    }
                    i = vt.endPtr - 1;
                    continue block7;
                }
                case 5: {
                    this.foreach(vt);
                }
                case 4: {
                    vt = (FormToken)this.formTokens.get(vt.cmdPtr);
                    if (vt.cmdType != 5 || vt.vc == null) continue block7;
                    if (++vt.pointCount == vt.vc.size()) {
                        i = vt.endPtr;
                        continue block7;
                    }
                    Object varData = vt.vc.get(vt.pointCount);
                    if (varData instanceof Coordinate) {
                        Coordinate c = (Coordinate)varData;
                        this.context.put("pointCount", new Integer(vt.pointCount));
                        this.context.put(vt.var + ".xVal", new Double(c.getXVal()));
                        this.context.put(vt.var + ".yVal", new Double(c.getYVal()));
                        this.context.put(vt.var + ".getXString()", c.getXString());
                        this.context.put(vt.var + ".getYString()", c.getYString());
                    } else if (varData instanceof Map) {
                        for (Map.Entry entry : ((Map)varData).entrySet()) {
                            this.context.put(vt.var + "." + (String)entry.getKey(), entry.getValue());
                        }
                    }
                    i = vt.cmdPtr;
                    continue block7;
                }
            }
        }
        return this.strError != null ? this.strError : (out != null ? out.toString() : null);
    }

    private void foreach(FormToken vt) {
        String data = vt.data;
        data = data.replace('(', ' ');
        String[] tokens = PT.getTokens(data = data.replace(')', ' '));
        if (tokens.length != 4) {
            return;
        }
        vt.var = tokens[1].substring(1);
        Object vc = this.context.get(tokens[3].substring(1));
        if (vc instanceof Lst) {
            vt.vc = (Lst)vc;
        }
        vt.cmdPtr = vt.ptr;
        vt.pointCount = -1;
    }

    private static int findOp(String op) {
        int i = ops.length;
        while (--i >= 0) {
            if (!ops[i].equals(op)) continue;
            return i;
        }
        return -1;
    }

    private boolean evaluate(String data, boolean isIf) {
        int pt = data.indexOf("(");
        if (pt < 0) {
            this.strError = "missing ( in " + data;
            return false;
        }
        if ((pt = (data = data.substring(pt + 1)).lastIndexOf(")")) < 0) {
            this.strError = "missing ) in " + data;
            return false;
        }
        data = data.substring(0, pt);
        data = PT.rep(data, "=", " = ");
        data = PT.rep(data, "!", " ! ");
        data = PT.rep(data, "<", " < ");
        data = PT.rep(data, ">", " > ");
        data = PT.rep(data, "=  =", "==");
        data = PT.rep(data, "<  =", "<=");
        data = PT.rep(data, ">  =", ">=");
        data = PT.rep(data, "!  =", "!=");
        String[] tokens = PT.getTokens(data);
        String key = tokens[0].substring(1);
        boolean isNot = false;
        boolean x = false;
        String value = null;
        String compare = "";
        try {
            switch (tokens.length) {
                case 1: {
                    value = this.getValue(key);
                    return !value.equals("") && !value.equals("false");
                }
                case 2: {
                    if (!key.equals("!")) break;
                    key = PT.trim(tokens[1], "$ ");
                    value = this.getValue(key);
                    return value.equals("false") || value.equals("");
                }
                case 3: {
                    key = PT.trim(tokens[0], "$ ");
                    value = this.getValue(key);
                    compare = PT.trim(tokens[2], " \"");
                    switch (FormContext.findOp(tokens[1])) {
                        case 0: 
                        case 2: {
                            return value.equals(compare);
                        }
                        case 1: {
                            return !value.equals(compare);
                        }
                    }
                    Logger.warn("???? " + key + " " + compare + " " + value);
                }
            }
        }
        catch (Exception e) {
            Logger.warn(e.toString() + " in VelocityContext.merge");
        }
        return isNot ? !x : x;
    }

    private String getValue(String key) {
        return this.context.containsKey(key) ? this.context.get(key).toString() : "";
    }

    private String fillData(String data) {
        int i = 0;
        int ccData = data.length();
        while (i < ccData) {
            String key;
            char ch;
            while (i < ccData && data.charAt(i++) != '$') {
            }
            if (i == ccData) break;
            int j = i;
            while (++j < ccData && (Character.isLetterOrDigit(ch = data.charAt(j)) || ch == '.' || ch == '_')) {
            }
            if (j < ccData && data.charAt(j) == '(') {
                j += 2;
            }
            if (!this.context.containsKey(key = data.substring(i, j))) continue;
            Object value = this.context.get(key);
            String strValue = value instanceof Coordinate ? value.toString() : value.toString();
            data = data.substring(0, i - 1) + strValue + data.substring(j);
            ccData = data.length();
            i += strValue.length();
        }
        return data;
    }

    class FormToken {
        boolean hasVariable;
        int cmdType;
        int cmdPtr = -1;
        int endPtr = -1;
        int ptr;
        String var;
        Lst<Object> vc;
        int pointCount;
        String data;

        FormToken(String token, int firstChar) {
            this.hasVariable = token.indexOf("$") >= 0;
            this.data = token;
            if (token.indexOf("#") != firstChar) {
                FormContext.this.formTokens.addLast(this);
                return;
            }
            this.ptr = FormContext.this.formTokens.size();
            boolean checkIf = false;
            if (token.indexOf("#end") == firstChar) {
                this.cmdType = 4;
                this.endPtr = this.ptr;
                --FormContext.this.commandLevel;
                if (FormContext.this.commandLevel < 0) {
                    FormContext.this.strError = "misplaced #end";
                    return;
                }
                this.cmdPtr = FormContext.this.cmds.removeItemAt(0);
                ((FormToken)FormContext.this.formTokens.get((int)this.cmdPtr)).endPtr = this.ptr;
            } else {
                FormToken vt;
                ++FormContext.this.commandLevel;
                if (token.indexOf("#if") == firstChar) {
                    this.cmdType = 1;
                    FormContext.this.cmds.add(0, new Integer(this.ptr));
                } else if (token.indexOf("#foreach") == firstChar) {
                    this.cmdType = 5;
                    FormContext.this.cmds.add(0, new Integer(this.ptr));
                    this.cmdPtr = this.ptr;
                    if (token.indexOf("#end") > 0) {
                        int pt = token.indexOf(")") + 1;
                        this.data = token.substring(0, pt);
                        FormContext.this.formTokens.addLast(this);
                        new FormToken(token.substring(pt, token.indexOf("#end")), 0);
                        new FormToken("#end", 0);
                        return;
                    }
                } else if (token.indexOf("#elseif") == firstChar) {
                    if (FormContext.this.cmds.size() == 0) {
                        FormContext.this.strError = "misplaced #elseif";
                        return;
                    }
                    this.cmdType = 3;
                    this.cmdPtr = FormContext.this.cmds.removeItemAt(0);
                    vt = (FormToken)FormContext.this.formTokens.get(this.cmdPtr);
                    checkIf = true;
                    vt.endPtr = this.ptr;
                    FormContext.this.cmds.add(0, new Integer(this.ptr));
                } else if (token.indexOf("#else") == firstChar) {
                    if (FormContext.this.cmds.size() == 0) {
                        FormContext.this.strError = "misplaced #else";
                        return;
                    }
                    this.cmdType = 2;
                    checkIf = true;
                    this.cmdPtr = FormContext.this.cmds.removeItemAt(0);
                    ((FormToken)FormContext.this.formTokens.get((int)this.cmdPtr)).endPtr = this.ptr;
                    FormContext.this.cmds.add(0, new Integer(this.ptr));
                } else {
                    Logger.warn("??? " + token);
                }
                if (checkIf) {
                    vt = (FormToken)FormContext.this.formTokens.get(this.cmdPtr);
                    if (vt.cmdType != 1 && vt.cmdType != 3) {
                        FormContext.this.strError = "misplaced " + token.trim();
                        return;
                    }
                }
            }
            FormContext.this.formTokens.addLast(this);
        }
    }
}

