/*
 * Decompiled with CFR 0.152.
 */
package gigahorse;

import com.typesafe.sslconfig.ssl.SSLConfigFactory$;
import com.typesafe.sslconfig.ssl.SSLConfigSettings;
import gigahorse.AuthScheme;
import gigahorse.AuthScheme$Basic$;
import gigahorse.AuthScheme$Digest$;
import gigahorse.AuthScheme$Kerberos$;
import gigahorse.AuthScheme$NTLM$;
import gigahorse.AuthScheme$SPNEGO$;
import gigahorse.Config;
import gigahorse.Config$;
import gigahorse.ConfigDefaults$;
import gigahorse.Realm;
import gigahorse.Realm$;
import gigahorse.RichXConfig;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.Charset;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.duration.Duration;
import scala.sys.package$;

public final class ConfigParser$ {
    public static ConfigParser$ MODULE$;
    private final String rootPath;

    static {
        new ConfigParser$();
    }

    public RichXConfig toRichXConfig(com.typesafe.config.Config config) {
        return new RichXConfig(config);
    }

    public String rootPath() {
        return this.rootPath;
    }

    public Config parse(com.typesafe.config.Config config0) {
        com.typesafe.config.Config config = config0.getConfig(this.rootPath());
        SSLConfigSettings sslConfig = config.hasPath("ssl") ? SSLConfigFactory$.MODULE$.parse(config.getConfig("ssl")) : SSLConfigFactory$.MODULE$.defaultConfig();
        Some authOpt = config.hasPath("auth") ? new Some((Object)this.parseRealm(config.getConfig("auth"))) : ConfigDefaults$.MODULE$.defaultAuthOpt();
        None$ cacheOpt = config.hasPath("cacheDirectory") ? new Some((Object)new File(config.getString("cacheDirectory"))) : None$.MODULE$;
        return Config$.MODULE$.apply(this.toRichXConfig(config).getFiniteDuration("connectTimeout", ConfigDefaults$.MODULE$.defaultConnectTimeout()), this.toRichXConfig(config).getFiniteDuration("requestTimeout", ConfigDefaults$.MODULE$.defaultRequestTimeout()), (Duration)this.toRichXConfig(config).getFiniteDuration("readTimeout", ConfigDefaults$.MODULE$.defaultReadTimeout()), this.toRichXConfig(config).getFiniteDuration("frameTimeout", ConfigDefaults$.MODULE$.defaultFrameTimeout()), this.toRichXConfig(config).getBoolean("followRedirects", ConfigDefaults$.MODULE$.defaultFollowRedirects()), this.toRichXConfig(config).getInt("maxRedirects", ConfigDefaults$.MODULE$.defaultMaxRedirects()), this.toRichXConfig(config).getBoolean("compressionEnforced", ConfigDefaults$.MODULE$.defaultCompressionEnforced()), this.toRichXConfig(config).getStringOption("userAgent", (Option<String>)ConfigDefaults$.MODULE$.defaultUserAgentOpt()), (Option<Realm>)authOpt, sslConfig, this.toRichXConfig(config).getInt("maxRequestRetry", ConfigDefaults$.MODULE$.defaultMaxRequestRetry()), this.toRichXConfig(config).getBoolean("disableUrlEncoding", ConfigDefaults$.MODULE$.defaultDisableUrlEncoding()), this.toRichXConfig(config).getBoolean("useProxyProperties", ConfigDefaults$.MODULE$.defaultUseProxyProperties()), this.toRichXConfig(config).getBoolean("keepAlive", ConfigDefaults$.MODULE$.defaultKeepAlive()), this.toRichXConfig(config).getDuration("pooledConnectionIdleTimeout", ConfigDefaults$.MODULE$.defaultPooledConnectionIdleTimeout()), this.toRichXConfig(config).getDuration("connectionTtl", (Duration)ConfigDefaults$.MODULE$.defaultConnectionTtl()), this.toRichXConfig(config).getInt("maxConnections", ConfigDefaults$.MODULE$.defaultMaxConnections()), this.toRichXConfig(config).getInt("maxConnectionsPerHost", ConfigDefaults$.MODULE$.defaultMaxConnectionsPerHost()), this.toRichXConfig(config).getMemorySize("maxFrameSize", ConfigDefaults$.MODULE$.defaultMaxFrameSize()), this.toRichXConfig(config).getMemorySize("webSocketMaxFrameSize", ConfigDefaults$.MODULE$.defaultWebSocketMaxFrameSize()), (Option<File>)cacheOpt, this.toRichXConfig(config).getMemorySize("maxCacheSize", ConfigDefaults$.MODULE$.defaultMaxCacheSize()));
    }

    public Realm parseRealm(com.typesafe.config.Config config) {
        return Realm$.MODULE$.apply(config.getString("username"), config.getString("password"), this.parseScheme(this.toRichXConfig(config).getString("scheme", "Basic")), this.toRichXConfig(config).getBoolean("usePreemptiveAuth", true), this.toRichXConfig(config).getStringOption("realmName", (Option<String>)None$.MODULE$), this.toRichXConfig(config).getStringOption("nonce", (Option<String>)None$.MODULE$), this.toRichXConfig(config).getStringOption("algorithm", (Option<String>)None$.MODULE$), this.toRichXConfig(config).getStringOption("response", (Option<String>)None$.MODULE$), this.toRichXConfig(config).getStringOption("opaque", (Option<String>)None$.MODULE$), this.toRichXConfig(config).getStringOption("qop", (Option<String>)None$.MODULE$), this.toRichXConfig(config).getStringOption("nc", (Option<String>)None$.MODULE$), (Option<URI>)this.toRichXConfig(config).getStringOption("uri", (Option<String>)None$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$1 -> new URI((String)x$1)), this.toRichXConfig(config).getStringOption("methodName", (Option<String>)None$.MODULE$), (Option<Charset>)this.toRichXConfig(config).getStringOption("charset", (Option<String>)None$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$1 -> Charset.forName(x$1)), this.toRichXConfig(config).getStringOption("ntlmDomain", (Option<String>)None$.MODULE$), this.toRichXConfig(config).getStringOption("ntlmHost", (Option<String>)None$.MODULE$), this.toRichXConfig(config).getBoolean("useAbsoluteURI", false), this.toRichXConfig(config).getBoolean("omitQuery", false));
    }

    public AuthScheme parseScheme(String s) {
        AuthScheme authScheme;
        String string = s.toLowerCase();
        if ("basic".equals(string)) {
            authScheme = AuthScheme$Basic$.MODULE$;
        } else if ("digest".equals(string)) {
            authScheme = AuthScheme$Digest$.MODULE$;
        } else if ("ntlm".equals(string)) {
            authScheme = AuthScheme$NTLM$.MODULE$;
        } else if ("spnego".equals(string)) {
            authScheme = AuthScheme$SPNEGO$.MODULE$;
        } else if ("kerberos".equals(string)) {
            authScheme = AuthScheme$Kerberos$.MODULE$;
        } else {
            throw package$.MODULE$.error(new StringBuilder(16).append("Invalid scheme: ").append(s).toString());
        }
        return authScheme;
    }

    private ConfigParser$() {
        MODULE$ = this;
        this.rootPath = "gigahorse";
    }
}

