/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc;

import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import sbt.internal.inc.ClassFileManager;
import sbt.internal.inc.JarUtils;
import sbt.internal.inc.JarUtils$;
import sbt.internal.inc.JavaInterfaceUtil$;
import sbt.util.Logger;
import sbt.util.Logger$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import xsbti.compile.ClassFileManager;
import xsbti.compile.ClassFileManagerType;
import xsbti.compile.DeleteImmediatelyManagerType;
import xsbti.compile.IncOptions;
import xsbti.compile.Output;
import xsbti.compile.TransactionalManagerType;
import xsbti.compile.WrappedClassFileManager;

public final class ClassFileManager$ {
    public static ClassFileManager$ MODULE$;

    static {
        new ClassFileManager$();
    }

    public ClassFileManager getDefaultClassFileManager(Optional<ClassFileManagerType> classFileManagerType) {
        ClassFileManager.DeleteClassFileManager deleteClassFileManager;
        if (classFileManagerType.isPresent()) {
            ClassFileManager.DeleteClassFileManager deleteClassFileManager2;
            ClassFileManagerType classFileManagerType2 = classFileManagerType.get();
            if (classFileManagerType2 instanceof DeleteImmediatelyManagerType) {
                deleteClassFileManager2 = new ClassFileManager.DeleteClassFileManager();
            } else if (classFileManagerType2 instanceof TransactionalManagerType) {
                TransactionalManagerType transactionalManagerType = (TransactionalManagerType)classFileManagerType2;
                deleteClassFileManager2 = this.transactional(transactionalManagerType.backupDirectory(), Logger$.MODULE$.xlog2Log(transactionalManagerType.logger()));
            } else {
                throw new MatchError((Object)classFileManagerType2);
            }
            deleteClassFileManager = deleteClassFileManager2;
        } else {
            deleteClassFileManager = new ClassFileManager.DeleteClassFileManager();
        }
        return deleteClassFileManager;
    }

    public ClassFileManager getClassFileManager(IncOptions options) {
        ClassFileManager internal = this.getDefaultClassFileManager(options.classfileManagerType());
        Option external = Option$.MODULE$.apply((Object)options.externalHooks()).flatMap((Function1 & Serializable & scala.Serializable)ext -> JavaInterfaceUtil$.MODULE$.EnrichOptional(ext.getExternalClassFileManager()).toOption());
        return WrappedClassFileManager.of((ClassFileManager)internal, JavaInterfaceUtil$.MODULE$.EnrichOption(external).toOptional());
    }

    public ClassFileManager getDefaultClassFileManager(Optional<ClassFileManagerType> classFileManagerType, Output output, JarUtils.OutputJarContent outputJarContent) {
        ClassFileManager classFileManager;
        if (classFileManagerType.isPresent()) {
            ClassFileManager classFileManager2;
            ClassFileManagerType classFileManagerType2 = classFileManagerType.get();
            if (classFileManagerType2 instanceof DeleteImmediatelyManagerType) {
                classFileManager2 = this.deleteImmediately(output, outputJarContent);
            } else if (classFileManagerType2 instanceof TransactionalManagerType) {
                TransactionalManagerType transactionalManagerType = (TransactionalManagerType)classFileManagerType2;
                classFileManager2 = this.transactional(output, outputJarContent, transactionalManagerType.backupDirectory(), Logger$.MODULE$.xlog2Log(transactionalManagerType.logger()));
            } else {
                throw new MatchError((Object)classFileManagerType2);
            }
            classFileManager = classFileManager2;
        } else {
            classFileManager = this.deleteImmediately(output, outputJarContent);
        }
        return classFileManager;
    }

    public ClassFileManager getClassFileManager(IncOptions options, Output output, JarUtils.OutputJarContent outputJarContent) {
        ClassFileManager internal = this.getDefaultClassFileManager(options.classfileManagerType(), output, outputJarContent);
        Option external = Option$.MODULE$.apply((Object)options.externalHooks()).flatMap((Function1 & Serializable & scala.Serializable)ext -> JavaInterfaceUtil$.MODULE$.EnrichOptional(ext.getExternalClassFileManager()).toOption());
        return WrappedClassFileManager.of((ClassFileManager)internal, JavaInterfaceUtil$.MODULE$.EnrichOption(external).toOptional());
    }

    public ClassFileManager deleteImmediately() {
        return new ClassFileManager.DeleteClassFileManager();
    }

    public ClassFileManager deleteImmediatelyFromJar(File outputJar, JarUtils.OutputJarContent outputJarContent) {
        return new ClassFileManager.DeleteClassFileManagerForJar(outputJar, outputJarContent);
    }

    public ClassFileManager deleteImmediately(Output output, JarUtils.OutputJarContent outputJarContent) {
        Option outputJar = JarUtils$.MODULE$.getOutputJar(output);
        return (ClassFileManager)outputJar.fold((Function0 & Serializable & scala.Serializable)() -> MODULE$.deleteImmediately(), (Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.deleteImmediatelyFromJar((File)x$1, outputJarContent));
    }

    public ClassFileManager transactional(File tempDir0, Logger logger) {
        return new ClassFileManager.TransactionalClassFileManager(tempDir0, logger);
    }

    public ClassFileManager transactionalForJar(File outputJar, JarUtils.OutputJarContent outputJarContent) {
        return new ClassFileManager.TransactionalClassFileManagerForJar(outputJar, outputJarContent);
    }

    public ClassFileManager transactional(Output output, JarUtils.OutputJarContent outputJarContent, File tempDir, Logger logger) {
        Option outputJar = JarUtils$.MODULE$.getOutputJar(output);
        return (ClassFileManager)outputJar.fold((Function0 & Serializable & scala.Serializable)() -> MODULE$.transactional(tempDir, logger), (Function1 & Serializable & scala.Serializable)x$2 -> MODULE$.transactionalForJar((File)x$2, outputJarContent));
    }

    private ClassFileManager$() {
        MODULE$ = this;
    }
}

