/****************************************************************************
** Shared Class code from reading file 'KReportLineStyle.shared.h'
**
** Created
**      by: The Shared Data Compiler version 0.3
**
** WARNING! All changes made in this file will be lost!
*****************************************************************************/

/* This file is part of the KDE project
 * Copyright (C) 2015 Jarosław Staniek <staniek@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef KREPORTLINESTYLE_H
#define KREPORTLINESTYLE_H

#include "kreport_export.h"

#include <QColor>
#include <QSharedData>

//! @brief The KReportLineStyle class represents line style
/*! @note objects of this class are explicitly shared, what means they behave like regular
          C++ pointers, except that by doing reference counting and not deleting the shared
          data object until the reference count is 0, they avoid the dangling pointer problem.
          See <a href="http://doc.qt.io/qt-5/qexplicitlyshareddatapointer.html#details">Qt documentation</a>.
 */
//! @note This class has been generated using the following SDC class options: explicit, operator==, virtual_dtor
class KREPORT_EXPORT KReportLineStyle
{
public:


    //! @internal data class used to implement explicitly shared class KReportLineStyle.
    //! Provides thread-safe reference counting.
    class Data : public QSharedData
    {
    public:
        Data()
        : weight(0.0)
        , penStyle(Qt::NoPen)
        {
        }

        Data(const Data &other)
         : QSharedData(other)
         , weight(other.weight)
         , color(other.color)
         , penStyle(other.penStyle)
        {
        }

        virtual ~Data() {}

        //! Clones the object with all attributes; the copy isn't shared with the original.
        virtual Data* clone() const { return new Data(*this); }

        qreal weight; //!< @see KReportLineStyle::weight(), KReportLineStyle::setWeight()
        QColor color; //!< @see KReportLineStyle::color(), KReportLineStyle::setColor()
        Qt::PenStyle penStyle; //!< @see KReportLineStyle::penStyle(), KReportLineStyle::setPenStyle()
    };

    KReportLineStyle()
     : d(new Data)
    {
    }

    KReportLineStyle(const KReportLineStyle &other)
     : d(other.d)
    {
    }

    virtual ~KReportLineStyle();

    /*!
    @return Line's width in points. The default is 0 points.
    */
    qreal weight() const {
        return d->weight;
    }

    /*!
    Sets the line's width to @a width.
    */
    void setWeight(qreal weight) {
        d->weight = weight;
    }

    /*!
    @return Line's color. The default is invalid color.
    */
    QColor color() const {
        return d->color;
    }

    /*!
    Sets the line's color to @a color.
    */
    void setColor(const QColor & color) {
        d->color = color;
    }

    /*!
    @return Line's pen style. The default is Qt::NoPen.
    */
    Qt::PenStyle penStyle() const {
        return d->penStyle;
    }

    /*!
    Sets the line's color to @a color.
    */
    void setPenStyle(const Qt::PenStyle & penStyle) {
        d->penStyle = penStyle;
    }

    //! @return true if this object is equal to @a other; otherwise returns false.
    bool operator==(const KReportLineStyle &other) const {
        return d == other.d;
    }

    //! @return true if this object is not equal to @a other; otherwise returns false.
    bool operator!=(const KReportLineStyle &other) const {
        return !operator==(other);
    }

    //! Clones the object with all attributes; the copy isn't shared with the original.
    virtual KReportLineStyle clone() const {
        return KReportLineStyle(d->clone());
    }


protected:
    KReportLineStyle(Data *data)
     : d(data)
    {
    }

    KReportLineStyle(QExplicitlySharedDataPointer<KReportLineStyle::Data> &data)
     : d(data)
    {
    }

    QExplicitlySharedDataPointer<Data> d;
};

template<>
KREPORT_EXPORT KReportLineStyle::Data *QSharedDataPointer<KReportLineStyle::Data>::clone();

#endif // KREPORTLABELELEMENT_H
