/**
 * SECTION:note-details
 * @short_description: Object representing a note that can have some parameters associated with it.
 * 
 * <para>See <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link> for details on common parameter names and values.</para>
 *
 * Since: 0.6.0
 */
/**
 * FOLKS_TYPE_NOTE_FIELD_DETAILS:
 * 
 * The type for <link linkend="FolksNoteFieldDetails"><type>FolksNoteFieldDetails</type></link>.
 */
/**
 * folks_note_field_details_new:
 * @value: (in): &nbsp;.  <para>the value of the field, which should be a non-empty free-form UTF-8 string as entered by the user </para>
 * @parameters: (in) (allow-none): &nbsp;.  <para>initial parameters. See <link linkend="FolksAbstractFieldDetails--parameters"><type>"parameters"</type></link>. A <code>null</code> value is equivalent to a empty map of parameters. </para>
 * @uid: (in) (allow-none): &nbsp;.  <para>UID for the note object itself, if known. A <code>null</code> value means the note has no unique ID. </para>
 * 
 * Create a new NoteFieldDetails.
 * 
 * Returns: <para>a new NoteFieldDetails </para>
 *
 * Since: 0.6.0
 */
/**
 * FolksNoteFieldDetails:uid:
 * 
 * The UID of the note (if any).
 *
 * Deprecated: 0.6.5: Replaced by #FolksAbstractFieldDetails:id.
 */
/**
 * folks_note_field_details_get_uid:
 * @self: the <link linkend="FolksNoteFieldDetails"><type>FolksNoteFieldDetails</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksNoteFieldDetails--uid"><type>"uid"</type></link> property.
 * 
 * The UID of the note (if any).
 * 
 * Returns: the value of the <link linkend="FolksNoteFieldDetails--uid"><type>"uid"</type></link> property
 *
 * Deprecated: 0.6.5: Replaced by #FolksAbstractFieldDetails:id.
 */
/**
 * folks_note_field_details_set_uid:
 * @self: the <link linkend="FolksNoteFieldDetails"><type>FolksNoteFieldDetails</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksNoteFieldDetails--uid"><type>"uid"</type></link> property
 * 
 * Set the value of the <link linkend="FolksNoteFieldDetails--uid"><type>"uid"</type></link> property to @value.
 * 
 * The UID of the note (if any).
 *
 * Deprecated: 0.6.5: Replaced by #FolksAbstractFieldDetails:id.
 */
/**
 * FolksNoteFieldDetails:
 * 
 * Object representing a note that can have some parameters associated with it.
 * 
 * <para>See <link linkend="FolksAbstractFieldDetails"><type>FolksAbstractFieldDetails</type></link> for details on common parameter names and values.</para>
 *
 * Since: 0.6.0
 */
/**
 * FolksNoteFieldDetailsClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="FOLKS-TYPE-NOTE-FIELD-DETAILS:CAPS"><literal>FOLKS_TYPE_NOTE_FIELD_DETAILS</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
/**
 * folks_note_details_change_notes:
 * @self: the <link linkend="FolksNoteDetails"><type>FolksNoteDetails</type></link> instance
 * @notes: (in): &nbsp;.  <para>the set of notes </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Change the contact&apos;s notes.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksNoteDetails--notes"><type>"notes"</type></link> directly, as this method gives error notification and will only return once the notes have been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the notes failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-note-details-change-notes-finish"><function>folks_note_details_change_notes_finish()</function></link>
 *
 * Since: 0.6.2
 */
/**
 * folks_note_details_change_notes_finish:
 * @self: the <link linkend="FolksNoteDetails"><type>FolksNoteDetails</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: (error-domains FolksPropertyError): location to store the error occurring, or %NULL to ignore
 * 
 * Change the contact&apos;s notes.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksNoteDetails--notes"><type>"notes"</type></link> directly, as this method gives error notification and will only return once the notes have been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the notes failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-note-details-change-notes"><function>folks_note_details_change_notes()</function></link>
 *
 * Since: 0.6.2
 */
/**
 * FolksNoteDetails:notes:
 * 
 * The notes about the contact.
 *
 * Since: 0.5.1
 */
/**
 * folks_note_details_get_notes:
 * @self: the <link linkend="FolksNoteDetails"><type>FolksNoteDetails</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksNoteDetails--notes"><type>"notes"</type></link> property.
 * 
 * The notes about the contact.
 * 
 * Returns: the value of the <link linkend="FolksNoteDetails--notes"><type>"notes"</type></link> property
 *
 * Since: 0.5.1
 */
/**
 * folks_note_details_set_notes:
 * @self: the <link linkend="FolksNoteDetails"><type>FolksNoteDetails</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksNoteDetails--notes"><type>"notes"</type></link> property
 * 
 * Set the value of the <link linkend="FolksNoteDetails--notes"><type>"notes"</type></link> property to @value.
 * 
 * The notes about the contact.
 *
 * Since: 0.5.1
 */
/**
 * FolksNoteDetails:
 * 
 * This interface represents the list of notes associated to a <link linkend="FolksPersona"><type>FolksPersona</type></link> and <link linkend="FolksIndividual"><type>FolksIndividual</type></link>.
 *
 * Since: 0.4.0
 */
/**
 * FolksNoteDetailsIface:
 * @change_notes: virtual method called by <link linkend="folks-note-details-change-notes"><function>folks_note_details_change_notes()</function></link>
 * @change_notes_finish: asynchronous finish function for <structfield>change_notes</structfield>, called by <link linkend="folks-note-details-change-notes"><function>folks_note_details_change_notes()</function></link>
 * @get_notes: getter method for the abstract property <link linkend="FolksNoteDetails--notes"><type>"notes"</type></link>
 * @set_notes: setter method for the abstract property <link linkend="FolksNoteDetails--notes"><type>"notes"</type></link>
 * @parent_iface: the parent interface structure
 * 
 * Interface for creating <link linkend="FolksNoteDetails"><type>FolksNoteDetails</type></link> implementations.
 */
