/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.Future;
import org.openstreetmap.josm.actions.SessionLoadAction;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadParams;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class DownloadSessionTask
extends AbstractDownloadTask<Object> {
    private static final String PATTERN_SESSION = "https?://.*/.*\\.jo(s|z)";
    private SessionLoadAction.Loader loader;

    @Override
    public String getTitle() {
        return I18n.tr("Download session", new Object[0]);
    }

    @Override
    public String[] getPatterns() {
        return new String[]{PATTERN_SESSION};
    }

    @Override
    public Future<?> download(DownloadParams settings, Bounds downloadArea, ProgressMonitor progressMonitor) {
        return null;
    }

    @Override
    public Future<?> loadUrl(DownloadParams settings, String url, ProgressMonitor progressMonitor) {
        if (url != null && url.matches(PATTERN_SESSION)) {
            try {
                URL u = new URL(url);
                this.loader = new SessionLoadAction.Loader(HttpClient.create(u).connect().getContent(), u.toURI(), url.endsWith(".joz"));
                return MainApplication.worker.submit(this.loader);
            }
            catch (IOException | URISyntaxException e) {
                Logging.error(e);
            }
        }
        return null;
    }

    @Override
    public void cancel() {
        if (this.loader != null) {
            this.loader.cancel();
        }
    }

    @Override
    public String getConfirmationMessage(URL url) {
        return null;
    }

    @Override
    public boolean isSafeForRemotecontrolRequests() {
        return Config.getPref().getBoolean("remotecontrol.import.allow_session", false);
    }
}

