/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.classfmt;

import org.eclipse.jdt.internal.compiler.classfmt.AnnotationInfo;
import org.eclipse.jdt.internal.compiler.classfmt.FieldInfo;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;

public class FieldInfoWithAnnotation
extends FieldInfo {
    private AnnotationInfo[] annotations;

    FieldInfoWithAnnotation(FieldInfo fieldInfo, AnnotationInfo[] annotationInfoArray) {
        super(fieldInfo.reference, fieldInfo.constantPoolOffsets, fieldInfo.structOffset);
        this.accessFlags = fieldInfo.accessFlags;
        this.attributeBytes = fieldInfo.attributeBytes;
        this.constant = fieldInfo.constant;
        this.constantPoolOffsets = fieldInfo.constantPoolOffsets;
        this.descriptor = fieldInfo.descriptor;
        this.name = fieldInfo.name;
        this.signature = fieldInfo.signature;
        this.signatureUtf8Offset = fieldInfo.signatureUtf8Offset;
        this.tagBits = fieldInfo.tagBits;
        this.wrappedConstantValue = fieldInfo.wrappedConstantValue;
        this.annotations = annotationInfoArray;
    }

    @Override
    public IBinaryAnnotation[] getAnnotations() {
        return this.annotations;
    }

    @Override
    protected void initialize() {
        if (this.annotations != null) {
            int n = this.annotations.length;
            for (int i = 0; i < n; ++i) {
                this.annotations[i].initialize();
            }
        }
        super.initialize();
    }

    @Override
    protected void reset() {
        if (this.annotations != null) {
            int n = this.annotations.length;
            for (int i = 0; i < n; ++i) {
                this.annotations[i].reset();
            }
        }
        super.reset();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        if (this.annotations != null) {
            stringBuffer.append('\n');
            for (int i = 0; i < this.annotations.length; ++i) {
                stringBuffer.append(this.annotations[i]);
                stringBuffer.append('\n');
            }
        }
        this.toStringContent(stringBuffer);
        return stringBuffer.toString();
    }
}

