/*
 * Decompiled with CFR 0.152.
 */
package gnu.mail.providers.nntp;

import gnu.inet.nntp.Group;
import gnu.inet.nntp.GroupIterator;
import gnu.inet.nntp.NNTPConnection;
import gnu.inet.nntp.NNTPException;
import gnu.mail.providers.nntp.ListFolderListener;
import gnu.mail.providers.nntp.NNTPFolder;
import gnu.mail.providers.nntp.NNTPStore;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.IllegalWriteException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Store;

public final class NNTPRootFolder
extends Folder {
    NNTPRootFolder(NNTPStore store) {
        super((Store)store);
    }

    public String getName() {
        NNTPStore ns = (NNTPStore)this.store;
        return ns.getURLName().getHost();
    }

    public String getFullName() {
        NNTPStore ns = (NNTPStore)this.store;
        return ns.connection.getWelcome();
    }

    public Folder[] list(String pattern) throws MessagingException {
        return this.list(pattern, null);
    }

    public Folder[] list(ListFolderListener listener) throws MessagingException {
        return this.list("%", listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Folder[] list(String pattern, ListFolderListener listener) throws MessagingException {
        pattern = pattern.replace('%', '*');
        try {
            NNTPStore ns = (NNTPStore)this.store;
            boolean listAll = ns.isListAll();
            LinkedList<NNTPFolder> acc = new LinkedList<NNTPFolder>();
            NNTPConnection nNTPConnection = ns.connection;
            synchronized (nNTPConnection) {
                GroupIterator i;
                GroupIterator groupIterator = i = listAll ? ns.connection.listActive(pattern) : ns.connection.listSubscriptions();
                while (i.hasNext()) {
                    Group group = i.nextGroup();
                    NNTPFolder folder = new NNTPFolder(ns, group.getName());
                    acc.add(folder);
                    if (listener == null) continue;
                    listener.foundFolder(group.getName());
                }
            }
            int len = acc.size();
            Folder[] folders = new Folder[len];
            acc.toArray(folders);
            return folders;
        }
        catch (NNTPException e) {
            switch (e.getResponse().getStatus()) {
                case 500: 
                case 501: 
                case 503: {
                    return this.listSubscribed(pattern);
                }
            }
            throw new MessagingException(e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
    }

    public Folder[] listSubscribed(String pattern) throws MessagingException {
        boolean hasWildcard = (pattern = pattern.replace('%', '*')).indexOf(42) > -1;
        boolean onlyWildcard = hasWildcard && pattern.length() == 0;
        NNTPStore ns = (NNTPStore)this.store;
        LinkedList<NNTPFolder> acc = new LinkedList<NNTPFolder>();
        Iterator i = ns.newsrc.list();
        while (i.hasNext()) {
            String name = (String)i.next();
            if (onlyWildcard) continue;
            if (hasWildcard && this.matches(name, pattern)) {
                acc.add(new NNTPFolder(ns, name));
                continue;
            }
            if (hasWildcard || !pattern.equals(name)) continue;
            acc.add(new NNTPFolder(ns, name));
        }
        int len = acc.size();
        Folder[] folders = new Folder[len];
        acc.toArray(folders);
        return folders;
    }

    boolean matches(String name, String pattern) {
        int i1 = pattern.indexOf(42);
        int pn = 0;
        int pp = 0;
        while (i1 > -1) {
            int len;
            String ns;
            String ps;
            if (i1 > 0) {
                ps = pattern.substring(pp, i1);
                if (!ps.equals(ns = name.substring(pn, len = ps.length()))) {
                    return false;
                }
                pp = i1 + 1;
                pn += len;
                i1 = 0;
                continue;
            }
            pp = i1 + 1;
            i1 = pattern.indexOf(42, pp);
            ps = null;
            ps = i1 == -1 ? pattern.substring(pp) : pattern.substring(pp, i1);
            len = ps.length();
            if (len <= 0 || ps.equals(ns = name.substring(pn, len))) continue;
            return false;
        }
        return true;
    }

    public Folder getFolder(String name) throws MessagingException {
        NNTPStore ns = (NNTPStore)this.store;
        return new NNTPFolder(ns, name);
    }

    public Folder getParent() throws MessagingException {
        return null;
    }

    public boolean exists() throws MessagingException {
        return true;
    }

    public char getSeparator() throws MessagingException {
        return '.';
    }

    public int getType() {
        return 2;
    }

    public void open(int mode) throws MessagingException {
        if (mode != 1) {
            throw new IllegalWriteException("Folder is read-only");
        }
    }

    public void close(boolean expunge) throws MessagingException {
    }

    public Message[] expunge() throws MessagingException {
        throw new IllegalWriteException("Folder is read-only");
    }

    public boolean isOpen() {
        return false;
    }

    public Flags getPermanentFlags() {
        return new Flags();
    }

    public int getMessageCount() throws MessagingException {
        return -1;
    }

    public Message getMessage(int msgnum) throws MessagingException {
        throw new IllegalStateException("Folder not open");
    }

    public void setSubscribed(boolean flag) throws MessagingException {
        if (!flag) {
            throw new IllegalWriteException("Can't unsubscribe root folder");
        }
    }

    public boolean hasNewMessages() throws MessagingException {
        return false;
    }

    public void appendMessages(Message[] messages) throws MessagingException {
        throw new IllegalWriteException("Folder is read-only");
    }

    public boolean create(int type) throws MessagingException {
        throw new MessagingException("Folder already exists");
    }

    public boolean delete(boolean flag) throws MessagingException {
        throw new IllegalWriteException("Folder is read-only");
    }

    public boolean renameTo(Folder folder) throws MessagingException {
        throw new IllegalWriteException("Folder is read-only");
    }
}

