/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.datatool;

import com.dickimawbooks.texparserlib.TeXApp;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolEntryRow;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolSty;
import java.io.IOException;
import java.util.Collection;
import java.util.Vector;

public class DataToolRows
extends Vector<DataToolEntryRow>
implements TeXObject {
    private DataToolSty sty;

    public DataToolRows(DataToolSty dataToolSty) {
        this.sty = dataToolSty;
    }

    public DataToolRows(DataToolSty dataToolSty, int n) {
        super(n);
        this.sty = dataToolSty;
    }

    @Override
    public Object clone() {
        DataToolRows dataToolRows = new DataToolRows(this.sty, this.capacity());
        for (DataToolEntryRow dataToolEntryRow : this) {
            dataToolRows.add((DataToolEntryRow)dataToolEntryRow.clone());
        }
        return dataToolRows;
    }

    @Override
    public synchronized void addElement(DataToolEntryRow dataToolEntryRow) {
        dataToolEntryRow.setRowIndex(this.size() + 1);
        super.addElement(dataToolEntryRow);
    }

    @Override
    public synchronized boolean add(DataToolEntryRow dataToolEntryRow) {
        dataToolEntryRow.setRowIndex(this.size() + 1);
        return super.add(dataToolEntryRow);
    }

    @Override
    public synchronized void insertElementAt(DataToolEntryRow dataToolEntryRow, int n) {
        super.insertElementAt(dataToolEntryRow, n);
        for (int i = n; i < this.size(); ++i) {
            ((DataToolEntryRow)this.get(i)).setRowIndex(i + 1);
        }
    }

    @Override
    public synchronized DataToolEntryRow set(int n, DataToolEntryRow dataToolEntryRow) {
        DataToolEntryRow dataToolEntryRow2 = super.set(n, dataToolEntryRow);
        for (int i = n; i < this.size(); ++i) {
            ((DataToolEntryRow)this.get(i)).setRowIndex(i + 1);
        }
        return dataToolEntryRow2;
    }

    @Override
    public synchronized void setElementAt(DataToolEntryRow dataToolEntryRow, int n) {
        super.setElementAt(dataToolEntryRow, n);
        for (int i = n; i < this.size(); ++i) {
            ((DataToolEntryRow)this.get(i)).setRowIndex(i + 1);
        }
    }

    @Override
    public synchronized boolean addAll(int n, Collection<? extends DataToolEntryRow> collection) {
        boolean bl = super.addAll(n, collection);
        for (int i = n; i < this.size(); ++i) {
            ((DataToolEntryRow)this.get(i)).setRowIndex(i + 1);
        }
        return bl;
    }

    @Override
    public synchronized boolean addAll(Collection<? extends DataToolEntryRow> collection) {
        int n = this.size();
        boolean bl = super.addAll(collection);
        for (int i = n; i < this.size(); ++i) {
            ((DataToolEntryRow)this.get(i)).setRowIndex(i + 1);
        }
        return bl;
    }

    @Override
    public synchronized void removeElementAt(int n) {
        super.removeElementAt(n);
        for (int i = n; i < this.size(); ++i) {
            ((DataToolEntryRow)this.get(i)).setRowIndex(i + 1);
        }
    }

    @Override
    public synchronized DataToolEntryRow remove(int n) {
        DataToolEntryRow dataToolEntryRow = (DataToolEntryRow)super.remove(n);
        for (int i = n; i < this.size(); ++i) {
            ((DataToolEntryRow)this.get(i)).setRowIndex(i + 1);
        }
        return dataToolEntryRow;
    }

    @Override
    protected synchronized void removeRange(int n, int n2) {
        super.removeRange(n, n2);
        for (int i = n; i < this.size(); ++i) {
            ((DataToolEntryRow)this.get(i)).setRowIndex(i + 1);
        }
    }

    public static DataToolRows toRows(TeXParser teXParser, TeXObjectList teXObjectList, DataToolSty dataToolSty, int n) throws IOException {
        DataToolEntryRow dataToolEntryRow;
        if (teXObjectList.peekStack() instanceof DataToolRows) {
            return (DataToolRows)teXObjectList.popToken();
        }
        DataToolRows dataToolRows = new DataToolRows(dataToolSty);
        int n2 = 0;
        TeXApp teXApp = null;
        if (n > 0) {
            teXApp = teXParser.getListener().getTeXApp();
            teXApp.progress(n2);
        }
        while ((dataToolEntryRow = DataToolEntryRow.toEntryRow(teXParser, teXObjectList, dataToolSty)) != null) {
            dataToolRows.add(dataToolEntryRow);
            if (teXApp == null) continue;
            teXApp.progress(100 * ++n2 / n);
        }
        return dataToolRows;
    }

    public DataToolEntryRow getRow(int n) {
        for (DataToolEntryRow dataToolEntryRow : this) {
            if (dataToolEntryRow.getRowIndex() != n) continue;
            return dataToolEntryRow;
        }
        return null;
    }

    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        for (DataToolEntryRow dataToolEntryRow : this) {
            teXObjectList.addAll(dataToolEntryRow.expandonce(teXParser));
        }
        return teXObjectList;
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        teXParser.addAll(0, this.expandonce(teXParser));
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.process(teXParser);
    }

    @Override
    public String toString(TeXParser teXParser) {
        try {
            return this.expandonce(teXParser).toString(teXParser);
        }
        catch (IOException iOException) {
            return "";
        }
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser).string(teXParser);
    }

    @Override
    public String format() {
        try {
            return this.expandonce(this.sty.getListener().getParser()).format();
        }
        catch (IOException iOException) {
            return "";
        }
    }

    @Override
    public boolean isPar() {
        return false;
    }
}

