/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.stream.Stream;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadParams;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.io.importexport.GpxImporter;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressTaskId;
import org.openstreetmap.josm.gui.progress.ProgressTaskIds;
import org.openstreetmap.josm.io.BoundingBoxDownloader;
import org.openstreetmap.josm.io.OsmServerLocationReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.UrlPatterns;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public class DownloadGpsTask
extends AbstractDownloadTask<GpxData> {
    private DownloadTask downloadTask;
    private GpxLayer gpxLayer;
    protected String url;

    @Override
    public String[] getPatterns() {
        return DownloadGpsTask.patterns(UrlPatterns.GpxUrlPattern.class);
    }

    @Override
    public String getTitle() {
        return I18n.tr("Download GPS", new Object[0]);
    }

    @Override
    public Future<?> download(DownloadParams settings, Bounds downloadArea, ProgressMonitor progressMonitor) {
        this.downloadTask = new DownloadTask(settings, new BoundingBoxDownloader(downloadArea), progressMonitor);
        return MainApplication.worker.submit(this.downloadTask);
    }

    @Override
    public Future<?> loadUrl(DownloadParams settings, String url, ProgressMonitor progressMonitor) {
        this.url = Objects.requireNonNull(url);
        Optional<String> mappedUrl = Stream.of(UrlPatterns.GpxUrlPattern.USER_TRACE_ID, UrlPatterns.GpxUrlPattern.EDIT_TRACE_ID).map(p -> p.matcher(url)).filter(Matcher::matches).map(m -> "https://www.openstreetmap.org/trace/" + m.group(2) + "/data").findFirst();
        if (mappedUrl.isPresent()) {
            return this.loadUrl(settings, mappedUrl.get(), progressMonitor);
        }
        if (Stream.of(UrlPatterns.GpxUrlPattern.TRACE_ID, UrlPatterns.GpxUrlPattern.EXTERNAL_GPX_SCRIPT, UrlPatterns.GpxUrlPattern.EXTERNAL_GPX_FILE, UrlPatterns.GpxUrlPattern.TASKING_MANAGER).anyMatch(p -> p.matches(url))) {
            this.downloadTask = new DownloadTask(settings, new OsmServerLocationReader(url), progressMonitor);
            return MainApplication.worker.submit(this.downloadTask);
        }
        if (UrlPatterns.GpxUrlPattern.TRACKPOINTS_BBOX.matches(url)) {
            String[] table = url.split("\\?|=|&", -1);
            for (int i = 0; i < table.length; ++i) {
                if (!"bbox".equals(table[i]) || i >= table.length - 1) continue;
                return this.download(settings, new Bounds(table[i + 1], ",", Bounds.ParseMethod.LEFT_BOTTOM_RIGHT_TOP), progressMonitor);
            }
        }
        return null;
    }

    @Override
    public void cancel() {
        if (this.downloadTask != null) {
            this.downloadTask.cancel();
        }
    }

    @Override
    public ProjectionBounds getDownloadProjectionBounds() {
        return this.gpxLayer != null ? this.gpxLayer.getViewProjectionBounds() : null;
    }

    @Override
    public String getConfirmationMessage(URL url) {
        return null;
    }

    @Override
    public boolean isSafeForRemotecontrolRequests() {
        return true;
    }

    class DownloadTask
    extends PleaseWaitRunnable {
        private final OsmServerReader reader;
        private GpxData rawData;
        private final boolean newLayer;

        DownloadTask(DownloadParams settings, OsmServerReader reader, ProgressMonitor progressMonitor) {
            super(I18n.tr("Downloading GPS data", new Object[0]), progressMonitor, false);
            this.reader = reader;
            this.newLayer = settings.isNewLayer();
        }

        @Override
        public void realRun() throws IOException, SAXException, OsmTransferException {
            try {
                if (DownloadGpsTask.this.isCanceled()) {
                    return;
                }
                this.rawData = this.reader.parseRawGps(this.progressMonitor.createSubTaskMonitor(-1, false));
            }
            catch (OsmTransferException e) {
                if (DownloadGpsTask.this.isCanceled()) {
                    return;
                }
                DownloadGpsTask.this.rememberException(e);
            }
        }

        @Override
        protected void finish() {
            DownloadGpsTask.this.rememberDownloadedData(this.rawData);
            if (this.rawData == null) {
                return;
            }
            String name = this.getLayerName();
            GpxImporter.GpxImporterData layers = GpxImporter.loadLayers(this.rawData, this.reader.isGpxParsedProperly(), name, I18n.tr("Markers from {0}", name));
            DownloadGpsTask.this.gpxLayer = layers.getGpxLayer();
            this.addOrMergeLayer(DownloadGpsTask.this.gpxLayer, this.findGpxMergeLayer());
            this.addOrMergeLayer(layers.getMarkerLayer(), this.findMarkerMergeLayer(DownloadGpsTask.this.gpxLayer));
            layers.getPostLayerTask().run();
        }

        private String getLayerName() {
            Matcher matcher = DownloadGpsTask.this.url != null ? UrlPatterns.GpxUrlPattern.EXTERNAL_GPX_FILE.matcher(DownloadGpsTask.this.url) : null;
            String newLayerName = matcher != null && matcher.matches() ? matcher.group(1) : null;
            String metadataName = this.rawData != null ? this.rawData.getString("meta.name") : null;
            String defaultName = I18n.tr("Downloaded GPX Data", new Object[0]);
            if (Config.getPref().getBoolean("gpx.prefermetadataname", false)) {
                return Utils.firstNotEmptyString(defaultName, metadataName, newLayerName);
            }
            return Utils.firstNotEmptyString(defaultName, newLayerName, metadataName);
        }

        private <L extends Layer> L addOrMergeLayer(L layer, L mergeLayer) {
            if (layer == null) {
                return null;
            }
            if (this.newLayer || mergeLayer == null) {
                MainApplication.getLayerManager().addLayer(layer, DownloadGpsTask.this.zoomAfterDownload);
                return layer;
            }
            mergeLayer.mergeFrom(layer);
            mergeLayer.invalidate();
            return mergeLayer;
        }

        private GpxLayer findGpxMergeLayer() {
            boolean merge = Config.getPref().getBoolean("download.gps.mergeWithLocal", false);
            Layer active = MainApplication.getLayerManager().getActiveLayer();
            if (active instanceof GpxLayer && (merge || ((GpxLayer)active).data.fromServer)) {
                return (GpxLayer)active;
            }
            return MainApplication.getLayerManager().getLayersOfType(GpxLayer.class).stream().filter(l -> merge || l.data.fromServer).findFirst().orElse(null);
        }

        private MarkerLayer findMarkerMergeLayer(GpxLayer fromLayer) {
            return MainApplication.getLayerManager().getLayersOfType(MarkerLayer.class).stream().filter(l -> fromLayer != null && l.fromLayer == fromLayer).findFirst().orElse(null);
        }

        @Override
        protected void cancel() {
            DownloadGpsTask.this.setCanceled(true);
            if (this.reader != null) {
                this.reader.cancel();
            }
        }

        @Override
        public ProgressTaskId canRunInBackground() {
            return ProgressTaskIds.DOWNLOAD_GPS;
        }
    }
}

