/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.StructUtils;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.ImageryLayerInfo;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.AbstractTileSourceLayer;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Logging;

public class OffsetBookmark {
    private static final List<OffsetBookmark> allBookmarks = new ArrayList<OffsetBookmark>();
    @StructUtils.StructEntry
    private String projection_code;
    @StructUtils.StructEntry
    private String imagery_id;
    @StructUtils.StructEntry
    private String imagery_name;
    @StructUtils.StructEntry
    private String name;
    @StructUtils.StructEntry
    @StructUtils.WriteExplicitly
    private double dx;
    @StructUtils.StructEntry
    @StructUtils.WriteExplicitly
    private double dy;
    @StructUtils.StructEntry
    private double center_lon;
    @StructUtils.StructEntry
    private double center_lat;

    public boolean isUsable(ImageryLayer layer) {
        if (this.projection_code == null) {
            return false;
        }
        if (!ProjectionRegistry.getProjection().toCode().equals(this.projection_code) && !this.hasCenter()) {
            return false;
        }
        ImageryInfo info = layer.getInfo();
        return this.imagery_id != null ? Objects.equals(info.getId(), this.imagery_id) : Objects.equals(info.getName(), this.imagery_name);
    }

    public OffsetBookmark() {
    }

    public OffsetBookmark(String projectionCode, String imageryId, String imageryName, String name, double dx, double dy) {
        this(projectionCode, imageryId, imageryName, name, dx, dy, 0.0, 0.0);
    }

    public OffsetBookmark(String projectionCode, String imageryId, String imageryName, String name, EastNorth displacement, ILatLon center) {
        this(projectionCode, imageryId, imageryName, name, displacement.east(), displacement.north(), center.lon(), center.lat());
    }

    public OffsetBookmark(String projectionCode, String imageryId, String imageryName, String name, double dx, double dy, double centerLon, double centerLat) {
        this.projection_code = projectionCode;
        this.imagery_id = imageryId;
        this.imagery_name = imageryName;
        this.name = name;
        this.dx = dx;
        this.dy = dy;
        this.center_lon = centerLon;
        this.center_lat = centerLat;
    }

    public String getProjectionCode() {
        return this.projection_code;
    }

    public String getName() {
        return this.name;
    }

    public String getImageryId() {
        return this.imagery_id;
    }

    public String getImageryName() {
        return this.imagery_name;
    }

    public EastNorth getDisplacement() {
        return new EastNorth(this.dx, this.dy);
    }

    public EastNorth getDisplacement(Projection proj) {
        if (proj.toCode().equals(this.projection_code)) {
            return this.getDisplacement();
        }
        LatLon center = this.getCenter();
        Projection offsetProj = Projections.getProjectionByCode(this.projection_code);
        EastNorth centerEN = center.getEastNorth(offsetProj);
        EastNorth shiftedEN = centerEN.add(this.getDisplacement());
        LatLon shifted = offsetProj.eastNorth2latlon(shiftedEN);
        EastNorth centerEN2 = center.getEastNorth(proj);
        EastNorth shiftedEN2 = shifted.getEastNorth(proj);
        return shiftedEN2.subtract(centerEN2);
    }

    public LatLon getCenter() {
        return new LatLon(this.center_lat, this.center_lon);
    }

    public boolean hasCenter() {
        return this.center_lat != 0.0 || this.center_lon != 0.0;
    }

    public void setProjectionCode(String projectionCode) {
        this.projection_code = projectionCode;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setImageryName(String imageryName) {
        this.imagery_name = imageryName;
    }

    public void setImageryId(String imageryId) {
        this.imagery_id = imageryId;
    }

    public void setDisplacement(EastNorth displacement) {
        this.dx = displacement.east();
        this.dy = displacement.north();
    }

    public static void loadBookmarks() {
        List<OffsetBookmark> bookmarks = StructUtils.getListOfStructs(Config.getPref(), "imagery.offsetbookmarks", null, OffsetBookmark.class);
        if (bookmarks != null) {
            OffsetBookmark.sanitizeBookmarks(bookmarks);
            allBookmarks.addAll(bookmarks);
        }
    }

    static void sanitizeBookmarks(List<OffsetBookmark> bookmarks) {
        bookmarks.stream().filter(b -> b.getImageryId() == null).forEach(b -> {
            List candidates = ImageryLayerInfo.instance.getLayers().stream().filter(l -> Objects.equals(l.getName(), b.getImageryName())).collect(Collectors.toList());
            if (candidates.size() == 1) {
                b.setImageryId(((ImageryInfo)candidates.get(0)).getId());
            } else {
                Logging.warn("Not a single layer for the name '" + b.getImageryName() + "': " + candidates);
            }
        });
        bookmarks.stream().filter(b -> b.getImageryId() != null).forEach(b -> {
            ImageryInfo info = ImageryLayerInfo.instance.getLayer(b.getImageryId());
            if (info != null && !Objects.equals(info.getName(), b.getImageryName())) {
                b.setImageryName(info.getName());
            }
        });
    }

    public static void saveBookmarks() {
        StructUtils.putListOfStructs(Config.getPref(), "imagery.offsetbookmarks", allBookmarks, OffsetBookmark.class);
    }

    public static List<OffsetBookmark> getBookmarks() {
        return Collections.unmodifiableList(allBookmarks);
    }

    public static int getBookmarksSize() {
        return allBookmarks.size();
    }

    public static boolean addBookmark(OffsetBookmark ob) {
        return allBookmarks.add(ob);
    }

    public static boolean removeBookmark(OffsetBookmark ob) {
        return allBookmarks.remove(ob);
    }

    public static OffsetBookmark getBookmarkByIndex(int index) {
        return allBookmarks.get(index);
    }

    public static OffsetBookmark getBookmarkByName(ImageryLayer layer, String name) {
        return allBookmarks.stream().filter(b -> b.isUsable(layer) && name.equals(b.name)).findFirst().orElse(null);
    }

    public static void bookmarkOffset(String name, AbstractTileSourceLayer<?> layer) {
        LatLon center = MainApplication.isDisplayingMapView() ? ProjectionRegistry.getProjection().eastNorth2latlon(MainApplication.getMap().mapView.getCenter()) : LatLon.ZERO;
        OffsetBookmark nb = new OffsetBookmark(ProjectionRegistry.getProjection().toCode(), layer.getInfo().getId(), layer.getInfo().getName(), name, layer.getDisplaySettings().getDisplacement(), center);
        ListIterator<OffsetBookmark> it = allBookmarks.listIterator();
        while (it.hasNext()) {
            OffsetBookmark b = it.next();
            if (!b.isUsable(layer) || !name.equals(b.name)) continue;
            it.set(nb);
            OffsetBookmark.saveBookmarks();
            return;
        }
        allBookmarks.add(nb);
        OffsetBookmark.saveBookmarks();
    }

    public Map<String, String> toPropertiesMap() {
        return StructUtils.serializeStruct(this, OffsetBookmark.class, new StructUtils.SerializeOptions[0]);
    }

    public static OffsetBookmark fromPropertiesMap(Map<String, String> properties) {
        return StructUtils.deserializeStruct(properties, OffsetBookmark.class);
    }
}

