/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PrimitiveRenderer;
import org.openstreetmap.josm.gui.dialogs.relation.ParentRelationLoadingTask;
import org.openstreetmap.josm.gui.dialogs.relation.ReferringRelationsBrowserModel;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.swing.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ReferringRelationsBrowser
extends JPanel {
    private JList<Relation> referrers;
    private final ReferringRelationsBrowserModel model;
    private final transient OsmDataLayer layer;
    private final JCheckBox cbReadFull = new JCheckBox(I18n.tr("including immediate children of parent relations", new Object[0]));
    private EditAction editAction;

    public ReferringRelationsBrowser(OsmDataLayer layer, ReferringRelationsBrowserModel model) {
        this.model = model;
        this.layer = layer;
        this.build();
    }

    protected void build() {
        this.setLayout(new BorderLayout());
        this.referrers = new JList<Relation>(this.model);
        this.referrers.setCellRenderer(new PrimitiveRenderer());
        this.add((Component)new JScrollPane(this.referrers), "Center");
        this.referrers.setSelectionMode(0);
        this.referrers.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Rectangle cellBounds;
                if (!(e.getClickCount() != 2 || e.isAltDown() || e.isAltGraphDown() || e.isControlDown() || e.isMetaDown() || e.isShiftDown() || (cellBounds = ReferringRelationsBrowser.this.referrers.getCellBounds(ReferringRelationsBrowser.this.referrers.getSelectedIndex(), ReferringRelationsBrowser.this.referrers.getSelectedIndex())) == null || !cellBounds.contains(e.getPoint()))) {
                    ReferringRelationsBrowser.this.editAction.actionPerformed(new ActionEvent(e.getSource(), 1001, null));
                }
            }
        });
        JPanel pnl = new JPanel(new FlowLayout(0));
        ReloadAction reloadAction = new ReloadAction();
        this.referrers.getModel().addListDataListener(reloadAction);
        pnl.add(new JButton(reloadAction));
        pnl.add(this.cbReadFull);
        this.editAction = new EditAction();
        this.referrers.getSelectionModel().addListSelectionListener(this.editAction);
        pnl.add(new JButton(this.editAction));
        this.add((Component)pnl, "South");
    }

    public void init() {
        this.model.populate(this.getLayer().data);
    }

    protected OsmDataLayer getLayer() {
        return this.layer;
    }

    class EditAction
    extends AbstractAction
    implements ListSelectionListener {
        EditAction() {
            this.putValue("ShortDescription", I18n.tr("Edit the currently selected relation", new Object[0]));
            new ImageProvider("dialogs", "edit").getResource().attachImageIcon(this);
            this.putValue("Name", I18n.tr("Edit", new Object[0]));
            this.refreshEnabled();
        }

        protected void refreshEnabled() {
            this.setEnabled(ReferringRelationsBrowser.this.referrers.getSelectionModel().getMinSelectionIndex() >= 0);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.run();
        }

        public void run() {
            int idx = ReferringRelationsBrowser.this.referrers.getSelectedIndex();
            if (idx < 0) {
                return;
            }
            Relation r = ReferringRelationsBrowser.this.model.getElementAt(idx);
            if (r == null) {
                return;
            }
            RelationEditor editor = RelationEditor.getEditor(ReferringRelationsBrowser.this.getLayer(), r, null);
            editor.setVisible(true);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.refreshEnabled();
        }
    }

    class ReloadAction
    extends AbstractAction
    implements ListDataListener {
        ReloadAction() {
            this.putValue("ShortDescription", I18n.tr("Load parent relations", new Object[0]));
            new ImageProvider("dialogs", "refresh").getResource().attachImageIcon(this);
            this.putValue("Name", I18n.tr("Reload", new Object[0]));
            this.refreshEnabled();
        }

        protected void refreshEnabled() {
            this.setEnabled(ReferringRelationsBrowser.this.model.canReload());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean full = ReferringRelationsBrowser.this.cbReadFull.isSelected();
            ParentRelationLoadingTask task = new ParentRelationLoadingTask(ReferringRelationsBrowser.this.model.getRelation(), ReferringRelationsBrowser.this.getLayer(), full, new PleaseWaitProgressMonitor(I18n.tr("Loading parent relations", new Object[0])));
            task.setContinuation(() -> {
                if (task.isCanceled() || task.hasError()) {
                    return;
                }
                ReferringRelationsBrowser.this.model.populate(task.getParents());
            });
            MainApplication.worker.submit(task);
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            this.refreshEnabled();
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.refreshEnabled();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.refreshEnabled();
        }
    }
}

