# KubeOne Reconciliation Process (`kubeone apply`) <!-- omit in toc -->

**Author:** Marko Mudrinić ([@xmudrii](https://github.com/xmudrii))  
**Status:** Draft | Review | **Final**  
**Created:** 2020-02-24  
**Last updated:** 2020-02-25  

## Table of Contents <!-- omit in toc -->

- [Abstract](#abstract)
- [Goals](#goals)
- [Non-goals](#non-goals)
- [Glossary](#glossary)
- [Implementation](#implementation)
  - [Probes](#probes)
  - [Reconciling The Cluster](#reconciling-the-cluster)
    - [The Cluster Is Not Provisioned](#the-cluster-is-not-provisioned)
    - [No Healthy Node Is Available or Quorum Is Not Satisfied (0 or 1 healthy node)](#no-healthy-node-is-available-or-quorum-is-not-satisfied-0-or-1-healthy-node)
    - [Non-Healthy Nodes are Present, but Quorum Is Satisfied (2/3 healthy nodes)](#non-healthy-nodes-are-present-but-quorum-is-satisfied-23-healthy-nodes)
    - [All Nodes Are Healthy](#all-nodes-are-healthy)
    - [Worker Nodes](#worker-nodes)
- [Deprecating Existing Subcommands](#deprecating-existing-subcommands)
- [Tasks & Efforts](#tasks--efforts)

## Abstract

KubeOne supports installing/provisioning and upgrading clusters, with repairs being
planned as well. Currently, all features are implemented as dedicated subcommands,
for example, `install` and `upgrade`. Instead of having a subcommand for each feature,
we want to implement the reconciliation process under the `apply` subcommand. `apply`
would analyze the provided cluster configuration file (the expected state) and the cluster
actual state, and based on the difference take the appropriate steps.
The appropriate steps can be operations such as install, upgrade, repair cluster,
apply missing manifest, create or rotate the worker nodes...

## Goals

* Implement the `apply` subcommand
  * Implement probes to detect the state of the cluster
  * Implement the logic to take the appropriate steps depending on
  the results returned by probes (e.g. install or upgrade the cluster)

## Non-goals

* Implement the repair process
* Automatically recover from cases when there is no healthy node or
  quorum is not satisfied
* Deprecate existing subcommands (`install` and `upgrade`)

## Glossary

* _etcd ring_: a group of etcd instances forming a single etcd cluster.
* _etcd member_: a known peer instance (running on the control-plane nodes) of
  etcd inside the etcd ring.

## Implementation

The reconciliation process is going to be invoked by the `kubeone apply` command.
The command takes the KubeOne cluster configuration manifest, which represents the
expected state, and optionally Terraform state and set of flags and options.

Example: `kubeone apply config.yaml -t tfstate.json`

Once invoked, the command takes the following steps:
* parse the provided cluster configuration to determine the expected state
* run probes to determine the actual state of the cluster
* run a specific set of actions to turn the actual state into the expected state (reconcile)
* re-run probes to ensure that actual and expected states of the cluster match

### Probes

Probes are used to determine the actual state of the cluster. They are implemented
as scripts to be executed over SSH or as Kubernetes API requests. For example, a
probe can check is `kubelet` running on a node or does all required pods exist.

The following probes **must** be implemented:

* is the cluster provisioned
* is a specific node provisioned, ready, and responsive
* is the actual Kubernetes version matching the desired version
* are the critical control plane pods running and healthy
* is the `etcd` ring healthy and in the expected state (all control plane nodes joined)
* is the actual cluster configuration matching the expected cluster configuration
* are worker nodes running and responsive

Some of the mentioned checks are already implemented in some form in `upgrade` and
`status` subcommands.

### Reconciling The Cluster

Depending on the actual state of the cluster determined by probes, KubeOne will try
to modify the cluster to match the expected state.

Some actions will be taken automatically, however, it is not planned to fully-automate
all actions. For example, if `kubeone apply` determines that a node needs to be repaired,
it would be up to the operator to create a new VM, update the cluster configuration
(or Terraform state) and then run `kubeone apply` again.

The following flowchart shows which actions are supported and how KubeOne makes the decision
based on the results returned by probes.

![kubeone apply flowchart](./apply-flowchart.svg)

The first step in the reconciliation process is to determine is the cluster provisioned
and the number of healthy nodes.

This is done by running the following checks:
* are all required packages installed (`docker`, `kubelet`, `kubeadm`)
* is the `/etc/kubernetes` directory present and non-empty
* is `kubelet` running and `/healthz` is reporting `ok`
* are the control plane pods running and healthy
* is a node part of the `etcd` ring

#### The Cluster Is Not Provisioned

This case is triggered when the `/etc/kubernetes` directory is absent or empty. This usually
happens when newly created VMs are provided or `kubeone reset` has been run. In this case,
`kubeone apply` would just invoke the installation process (`kubeone install`).

It is important to make a difference between this case and the case when there is no healthy
node in the cluster (but the cluster has been provisioned), as different steps should be taken.

#### No Healthy Node Is Available or Quorum Is Not Satisfied (0 or 1 healthy node)

If KubeOne determines that the number of healthy nodes is not enough to
satisfy the [quorum][etcd-quorum] (e.g. 0 or 1 healthy node), KubeOne will
return an error.

In such a case, the `etcd` data integrity could **not** be guaranteed. It is
required that operator take the following steps:
* run `kubeone reset` to unprovision the cluster
* run `kubeone apply` to reprovision the cluster
* restore the backup

An automated way for recovering from such scenario is a non-goal for this proposal.

#### Non-Healthy Nodes are Present, but Quorum Is Satisfied (2/3 healthy nodes)

If KubeOne determines that there are non-healthy nodes in the cluster, but
the [quorum][etcd-quorum] is satisfied (e.g. 2 out of 3 nodes are healthy),
KubeOne will attempt to automatically repair the cluster.

A node is marked as non-healthy if:
* `kubelet` is not running, is failing, or `/healthz` is reporting an error
* core components are not running and/or healthy
* the appropriate `etcd` member is not part of the `etcd` ring

In such cases, there is a high chance that rotating the node will fix the problem
and ensure that the cluster can continue working as expected.

The operator would have to manually remove the non-healthy instance
from the (cloud) provider and then update the KubeOne configuration to replace the old
instance with a new one. Running the `kubeone apply` command the next time would
remove the old `etcd` member from the `etcd` ring and then invoke the
installation process (`kubeone install`) to provision the new node.
This process is explained in the [manual cluster repair][manual-cluster-repair] document.

Automatic repairs are a non-goal for this proposal, however, the repairs feature
is expected in the future.

#### All Nodes Are Healthy

If all nodes are healthy, the reconciliation process compares the actual
cluster state and the expected state. That includes checks such as:
* Kubernetes versions match
* All requested features are enabled
* Features that are not present in the expected state and are disabled by default,
  are disabled in the cluster
* Features that are not present in the expected state and are enabled by default,
  are enabled in the cluster
* MachineDeployments defined in the expected state match MachineDeployments present
  in the cluster

Depending on the case, the appropriate steps would be taken, such as upgrade the
cluster, enable/disable features, create a new MachineDeployment...

#### Worker Nodes

The health checks/probes described above will be done on the worker nodes as well,
as long as:
* the worker nodes are managed by `machine-controller`
* it is possible to access the worker nodes over SSH

If one of the requirements is not satisfied, it is up to the operator to repair
the worker nodes.

Similar to control plane nodes, if KubeOne detects a non-healthy worker node, it
will be evicted and rotated.

## Deprecating Existing Subcommands

Deprecating existing subcommands (`install`, `upgrade` and `status`) is a non-goal
for this proposal. At some point, it might be decided to deprecate those subcommands,
however, that depends on the actual implementation of the `apply` command. In the case
we decide to deprecate the subcommands, a new proposal will be written, with the backwards
compatibility policy in mind.

## Tasks & Efforts

* Implement probes as described in the Probes section
* Implement the cluster reconciliation process
* Write E2E tests for the `kubeone apply` command
* Write and/or update documentation

[etcd-quorum]: https://github.com/etcd-io/etcd/blob/master/Documentation/faq.md#why-an-odd-number-of-cluster-members
[manual-cluster-repair]: ../manual-cluster-repair.md