/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common.model;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import javax.swing.DefaultButtonModel;
import javax.swing.Timer;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.model.ActionButtonModel;

public class ActionRepeatableButtonModel
extends DefaultButtonModel
implements ActionButtonModel {
    private JCommandButton commandButton;
    protected Timer autoRepeatTimer;
    protected boolean toFireActionOnPress;

    public ActionRepeatableButtonModel(JCommandButton commandButton) {
        this.commandButton = commandButton;
        this.toFireActionOnPress = false;
    }

    @Override
    public void setPressed(boolean b) {
        if (this.isPressed() == b || !this.isEnabled()) {
            return;
        }
        this.stateMask = b ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
        boolean toFireFirstAction = this.isArmed();
        if (this.commandButton.isAutoRepeatAction() || this.isFireActionOnPress()) {
            toFireFirstAction = this.isPressed() && toFireFirstAction;
        } else {
            boolean bl = toFireFirstAction = !this.isPressed() && toFireFirstAction;
        }
        if (this.commandButton.getCommandButtonKind() == JCommandButton.CommandButtonKind.POPUP_ONLY) {
            toFireFirstAction = false;
        }
        if (this.commandButton.isFireActionOnRollover()) {
            toFireFirstAction = false;
        }
        int modifiers = 0;
        AWTEvent currentEvent = EventQueue.getCurrentEvent();
        if (currentEvent instanceof InputEvent) {
            modifiers = ((InputEvent)currentEvent).getModifiers();
        } else if (currentEvent instanceof ActionEvent) {
            modifiers = ((ActionEvent)currentEvent).getModifiers();
        }
        if (toFireFirstAction) {
            this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand(), EventQueue.getMostRecentEventTime(), modifiers));
            if (this.commandButton.isAutoRepeatAction()) {
                this.startActionTimer(modifiers);
            }
        }
        if (!this.commandButton.isFireActionOnRollover() && this.commandButton.isAutoRepeatAction() && !b) {
            this.stopActionTimer();
        }
        this.fireStateChanged();
    }

    @Override
    public void setRollover(boolean b) {
        if (this.isRollover() == b || !this.isEnabled()) {
            return;
        }
        this.stateMask = b ? (this.stateMask |= 0x10) : (this.stateMask &= 0xFFFFFFEF);
        if (this.commandButton.isFireActionOnRollover()) {
            if (b && !this.isActionTimerRunning() && this.commandButton.getCommandButtonKind() != JCommandButton.CommandButtonKind.POPUP_ONLY) {
                int modifiers = 0;
                AWTEvent currentEvent = EventQueue.getCurrentEvent();
                if (currentEvent instanceof InputEvent) {
                    modifiers = ((InputEvent)currentEvent).getModifiers();
                } else if (currentEvent instanceof ActionEvent) {
                    modifiers = ((ActionEvent)currentEvent).getModifiers();
                }
                this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand(), EventQueue.getMostRecentEventTime(), modifiers));
                if (this.commandButton.isAutoRepeatAction()) {
                    this.startActionTimer(modifiers);
                }
            }
            if (!b) {
                this.stopActionTimer();
            }
        }
        this.fireStateChanged();
    }

    private void stopActionTimer() {
        if (this.autoRepeatTimer != null) {
            this.autoRepeatTimer.stop();
        }
    }

    private boolean isActionTimerRunning() {
        if (this.autoRepeatTimer == null) {
            return false;
        }
        return this.autoRepeatTimer.isRunning();
    }

    private void startActionTimer(final int modifiers) {
        this.autoRepeatTimer = new Timer(this.commandButton.getAutoRepeatSubsequentInterval(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!(ActionRepeatableButtonModel.this.isEnabled() && ActionRepeatableButtonModel.this.commandButton.isVisible() && ActionRepeatableButtonModel.this.commandButton.isDisplayable())) {
                    ActionRepeatableButtonModel.this.autoRepeatTimer.stop();
                    return;
                }
                ActionRepeatableButtonModel.this.fireActionPerformed(new ActionEvent(this, 1001, ActionRepeatableButtonModel.this.getActionCommand(), EventQueue.getMostRecentEventTime(), modifiers));
            }
        });
        this.autoRepeatTimer.setInitialDelay(this.commandButton.getAutoRepeatInitialInterval());
        this.autoRepeatTimer.start();
    }

    @Override
    public boolean isFireActionOnPress() {
        return this.toFireActionOnPress;
    }

    @Override
    public void setFireActionOnPress(boolean toFireActionOnPress) {
        this.toFireActionOnPress = toFireActionOnPress;
    }
}

