/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin.force;

import org.gephi.graph.spi.LayoutData;

public class ForceVector
implements LayoutData {
    protected float x;
    protected float y;

    public ForceVector(ForceVector vector) {
        this.x = vector.x();
        this.y = vector.y();
    }

    public ForceVector(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public ForceVector() {
        this.x = 0.0f;
        this.y = 0.0f;
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public float z() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void add(ForceVector f) {
        if (f != null) {
            this.x += f.x();
            this.y += f.y();
        }
    }

    public void multiply(float s) {
        this.x *= s;
        this.y *= s;
    }

    public void subtract(ForceVector f) {
        if (f != null) {
            this.x -= f.x();
            this.y -= f.y();
        }
    }

    public float getEnergy() {
        return this.x * this.x + this.y * this.y;
    }

    public float getNorm() {
        return (float)Math.sqrt(this.getEnergy());
    }

    public ForceVector normalize() {
        float norm = this.getNorm();
        return new ForceVector(this.x / norm, this.y / norm);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }
}

