/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.exporter.plugin;

import java.io.Writer;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.io.exporter.api.FileType;
import org.gephi.io.exporter.spi.CharacterExporter;
import org.gephi.io.exporter.spi.GraphExporter;
import org.gephi.project.api.Workspace;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.NbBundle;

public class ExporterPajek
implements GraphExporter,
CharacterExporter,
LongTask {
    private boolean exportPosition = true;
    private boolean exportEdgeWeight = true;
    private Workspace workspace;
    private Writer writer;
    private boolean exportVisible;
    private boolean cancel = false;
    private ProgressTicket progressTicket;

    public void setExportEdgeWeight(boolean exportEdgeWeight) {
        this.exportEdgeWeight = exportEdgeWeight;
    }

    public boolean isExportEdgeWeight() {
        return this.exportEdgeWeight;
    }

    public void setExportPosition(boolean exportPosition) {
        this.exportPosition = exportPosition;
    }

    public boolean isExportPosition() {
        return this.exportPosition;
    }

    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progressTicket = progressTicket;
    }

    public boolean isExportVisible() {
        return this.exportVisible;
    }

    public void setExportVisible(boolean exportVisible) {
        this.exportVisible = exportVisible;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public String getName() {
        return NbBundle.getMessage(this.getClass(), (String)"ExporterPajek_name");
    }

    public FileType[] getFileTypes() {
        FileType ft = new FileType(".net", NbBundle.getMessage(this.getClass(), (String)"fileType_Pajek_Name"));
        return new FileType[]{ft};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() {
        GraphModel graphModel = (GraphModel)this.workspace.getLookup().lookup(GraphModel.class);
        Graph graph = this.exportVisible ? graphModel.getGraphVisible() : graphModel.getGraph();
        graph.readLock();
        try {
            this.exportData(graph);
        }
        catch (Exception e) {
            Logger.getLogger(ExporterPajek.class.getName()).log(Level.SEVERE, null, e);
        }
        finally {
            graph.readUnlock();
            Progress.finish((ProgressTicket)this.progressTicket);
        }
        return !this.cancel;
    }

    private void exportData(Graph graph) throws Exception {
        int max = graph.getNodeCount();
        int i = 1;
        HashMap<String, Integer> idx = new HashMap<String, Integer>(3 * max / 2 + 1);
        Progress.start((ProgressTicket)this.progressTicket, (int)max);
        this.writer.append("*Vertices " + max + "\n");
        NodeIterable nodeIterable = graph.getNodes();
        for (Node node : nodeIterable) {
            this.writer.append(Integer.toString(i));
            this.writer.append(" \"" + node.getLabel() + "\"");
            if (this.exportPosition) {
                this.writer.append(" " + node.x() + " " + node.y() + " " + node.z());
            }
            this.writer.append("\n");
            idx.put(node.getId().toString(), i++);
            if (!this.cancel) continue;
            nodeIterable.doBreak();
            return;
        }
        if (graph.isUndirected()) {
            this.writer.append("*Edges\n");
        } else {
            this.writer.append("*Arcs\n");
        }
        EdgeIterable edgeIterable = graph.getEdges();
        for (Edge edge : edgeIterable) {
            if (this.cancel) {
                edgeIterable.doBreak();
                return;
            }
            this.writer.append(Integer.toString((Integer)idx.get(edge.getSource().getId().toString())) + " ");
            this.writer.append(Integer.toString((Integer)idx.get(edge.getTarget().getId().toString())));
            if (this.exportEdgeWeight) {
                this.writer.append(" " + edge.getWeight());
            }
            this.writer.append("\n");
            Progress.progress((ProgressTicket)this.progressTicket);
        }
        Progress.finish((ProgressTicket)this.progressTicket);
    }
}

