"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const shebang_1 = require("../shebang");
describe('hasBashShebang', () => {
    it('returns false for empty file', () => {
        expect(shebang_1.hasBashShebang('')).toBe(false);
    });
    it('returns false for python files', () => {
        expect(shebang_1.hasBashShebang(`#!/usr/bin/env python2.7\n# set -x`)).toBe(false);
    });
    it('returns true for "#!/bin/sh -"', () => {
        expect(shebang_1.hasBashShebang('#!/bin/sh -')).toBe(true);
        expect(shebang_1.hasBashShebang('#!/bin/sh - ')).toBe(true);
    });
    it('returns true for "#!/usr/bin/env bash"', () => {
        expect(shebang_1.hasBashShebang('#!/usr/bin/env bash')).toBe(true);
        expect(shebang_1.hasBashShebang('#!/usr/bin/env bash ')).toBe(true);
    });
    it('returns true for "#!/bin/sh"', () => {
        expect(shebang_1.hasBashShebang('#!/bin/sh')).toBe(true);
        expect(shebang_1.hasBashShebang('#!/bin/sh ')).toBe(true);
    });
    it('returns true for "#!/bin/bash"', () => {
        expect(shebang_1.hasBashShebang('#!/bin/bash')).toBe(true);
        expect(shebang_1.hasBashShebang('#!/bin/bash ')).toBe(true);
    });
});
//# sourceMappingURL=shebang.test.js.map