/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.ivy.plugins.repository.ssh.RemoteScpException;

public class Scp {
    private static final int MODE_LENGTH = 4;
    private static final int SEND_FILE_BUFFER_LENGTH = 40000;
    private static final int SEND_BYTES_BUFFER_LENGTH = 512;
    private static final int MIN_TLINE_LENGTH = 8;
    private static final int CLINE_SPACE_INDEX2 = 5;
    private static final int CLINE_SPACE_INDEX1 = 4;
    private static final int MIN_C_LINE_LENGTH = 8;
    private static final int DEFAULT_LINE_BUFFER_LENGTH = 30;
    private static final int BUFFER_SIZE = 65536;
    private static final int MAX_SCP_LINE_LENGTH = 8192;
    private Session session;

    public Scp(Session session) {
        if (session == null) {
            throw new IllegalArgumentException("Cannot accept null argument!");
        }
        this.session = session;
    }

    private void readResponse(InputStream inputStream) throws IOException, RemoteScpException {
        int n = inputStream.read();
        if (n == 0) {
            return;
        }
        if (n == -1) {
            throw new RemoteScpException("Remote scp terminated unexpectedly.");
        }
        if (n != 1 && n != 2) {
            throw new RemoteScpException("Remote scp sent illegal error code.");
        }
        if (n == 2) {
            throw new RemoteScpException("Remote scp terminated with error.");
        }
        String string = this.receiveLine(inputStream);
        throw new RemoteScpException("Remote scp terminated with error (" + string + ").");
    }

    private String receiveLine(InputStream inputStream) throws IOException, RemoteScpException {
        StringBuffer stringBuffer = new StringBuffer(30);
        while (true) {
            if (stringBuffer.length() > 8192) {
                throw new RemoteScpException("Remote scp sent a too long line");
            }
            int n = inputStream.read();
            if (n < 0) {
                throw new RemoteScpException("Remote scp terminated unexpectedly.");
            }
            if (n == 10) break;
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    private void parseCLine(String string, FileInfo fileInfo) throws RemoteScpException {
        long l;
        if (string.length() < 8) {
            throw new RemoteScpException("Malformed C line sent by remote SCP binary, line too short.");
        }
        if (string.charAt(4) != ' ' || string.charAt(5) == ' ') {
            throw new RemoteScpException("Malformed C line sent by remote SCP binary.");
        }
        int n = string.indexOf(32, 5);
        if (n == -1) {
            throw new RemoteScpException("Malformed C line sent by remote SCP binary.");
        }
        String string2 = string.substring(5, n);
        String string3 = string.substring(n + 1);
        if (string2.length() <= 0 || string3.length() <= 0) {
            throw new RemoteScpException("Malformed C line sent by remote SCP binary.");
        }
        if (6 + string2.length() + string3.length() != string.length()) {
            throw new RemoteScpException("Malformed C line sent by remote SCP binary.");
        }
        try {
            l = Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new RemoteScpException("Malformed C line sent by remote SCP binary, cannot parse file length.");
        }
        if (l < 0L) {
            throw new RemoteScpException("Malformed C line sent by remote SCP binary, illegal file length.");
        }
        fileInfo.setLength(l);
        fileInfo.setFilename(string3);
    }

    private void parseTLine(String string, FileInfo fileInfo) throws RemoteScpException {
        long l;
        long l2;
        long l3;
        long l4;
        if (string.length() < 8) {
            throw new RemoteScpException("Malformed T line sent by remote SCP binary, line too short.");
        }
        int n = string.indexOf(" ") + 1;
        if (n == 0 || n >= string.length()) {
            throw new RemoteScpException("Malformed T line sent by remote SCP binary, line not enough data.");
        }
        int n2 = string.indexOf(" ", n + 1) + 1;
        if (n2 == 0 || n2 >= string.length()) {
            throw new RemoteScpException("Malformed T line sent by remote SCP binary, line not enough data.");
        }
        int n3 = string.indexOf(" ", n2 + 1) + 1;
        if (n3 == 0 || n3 >= string.length()) {
            throw new RemoteScpException("Malformed T line sent by remote SCP binary, line not enough data.");
        }
        try {
            l4 = Long.parseLong(string.substring(0, n - 1));
            l3 = Long.parseLong(string.substring(n, n2 - 1));
            l2 = Long.parseLong(string.substring(n2, n3 - 1));
            l = Long.parseLong(string.substring(n3));
        }
        catch (NumberFormatException numberFormatException) {
            throw new RemoteScpException("Malformed C line sent by remote SCP binary, cannot parse file length.");
        }
        if (l4 < 0L || l3 < 0L || l2 < 0L || l < 0L) {
            throw new RemoteScpException("Malformed C line sent by remote SCP binary, illegal file length.");
        }
        fileInfo.setLastModified(l4);
    }

    private void sendFile(Channel channel, String string, String string2, String string3) throws IOException, RemoteScpException {
        byte[] byArray = new byte[65536];
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(channel.getOutputStream(), 40000);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(channel.getInputStream(), 512);
        try {
            if (channel.isConnected()) {
                channel.start();
            } else {
                channel.connect();
            }
        }
        catch (JSchException jSchException) {
            throw (IOException)new IOException("Channel connection problems").initCause(jSchException);
        }
        this.readResponse(bufferedInputStream);
        File file = new File(string);
        long l = file.length();
        String string4 = string3;
        if (string4 == null) {
            string4 = "0600";
        }
        String string5 = "C" + string4 + " " + l + " " + string2 + "\n";
        ((OutputStream)bufferedOutputStream).write(string5.getBytes());
        ((OutputStream)bufferedOutputStream).flush();
        this.readResponse(bufferedInputStream);
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            while (l > 0L) {
                int n = l > (long)byArray.length ? byArray.length : (int)l;
                if (fileInputStream.read(byArray, 0, n) != n) {
                    throw new IOException("Cannot read enough from local file " + string);
                }
                ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
                l -= (long)n;
            }
            fileInputStream.close();
        }
        catch (IOException iOException) {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            throw iOException;
        }
        ((OutputStream)bufferedOutputStream).write(0);
        ((OutputStream)bufferedOutputStream).flush();
        this.readResponse(bufferedInputStream);
        ((OutputStream)bufferedOutputStream).write("E\n".getBytes());
        ((OutputStream)bufferedOutputStream).flush();
    }

    private FileInfo receiveStream(Channel channel, String string, OutputStream outputStream) throws IOException, RemoteScpException {
        String string2;
        int n;
        byte[] byArray = new byte[65536];
        OutputStream outputStream2 = channel.getOutputStream();
        InputStream inputStream = channel.getInputStream();
        try {
            if (channel.isConnected()) {
                channel.start();
            } else {
                channel.connect();
            }
        }
        catch (JSchException jSchException) {
            throw (IOException)new IOException("Channel connection problems").initCause(jSchException);
        }
        outputStream2.write(0);
        outputStream2.flush();
        FileInfo fileInfo = new FileInfo();
        while (true) {
            if ((n = inputStream.read()) < 0) {
                throw new RemoteScpException("Remote scp terminated unexpectedly.");
            }
            string2 = this.receiveLine(inputStream);
            if (n != 84) break;
            this.parseTLine(string2, fileInfo);
            outputStream2.write(0);
            outputStream2.flush();
        }
        if (n == 1 || n == 2) {
            throw new RemoteScpException("Remote SCP error: " + string2);
        }
        if (n != 67) {
            throw new RemoteScpException("Remote SCP error: " + (char)n + string2);
        }
        this.parseCLine(string2, fileInfo);
        if (outputStream != null) {
            outputStream2.write(0);
            outputStream2.flush();
            try {
                int n2;
                for (long i = fileInfo.getLength(); i > 0L; i -= (long)n2) {
                    int n3 = i > (long)byArray.length ? byArray.length : (int)i;
                    n2 = inputStream.read(byArray, 0, n3);
                    if (n2 < 0) {
                        throw new IOException("Remote scp terminated connection unexpectedly");
                    }
                    outputStream.write(byArray, 0, n2);
                }
                outputStream.close();
            }
            catch (IOException iOException) {
                if (outputStream != null) {
                    outputStream.close();
                }
                throw iOException;
            }
            this.readResponse(inputStream);
            outputStream2.write(0);
            outputStream2.flush();
        }
        return fileInfo;
    }

    private ChannelExec getExecChannel() throws JSchException {
        ChannelExec channelExec = (ChannelExec)this.session.openChannel("exec");
        return channelExec;
    }

    public void put(String string, String string2, String string3, String string4) throws IOException, RemoteScpException {
        ChannelExec channelExec = null;
        if (string == null || string3 == null) {
            throw new IllegalArgumentException("Null argument.");
        }
        if (string4 != null) {
            if (string4.length() != 4) {
                throw new IllegalArgumentException("Invalid mode.");
            }
            for (int i = 0; i < string4.length(); ++i) {
                if (Character.isDigit(string4.charAt(i))) continue;
                throw new IllegalArgumentException("Invalid mode.");
            }
        }
        String string5 = "scp -t ";
        if (string4 != null) {
            string5 = string5 + "-p ";
        }
        if (string2 != null && string2.length() > 0) {
            string5 = string5 + "-d " + string2;
        }
        try {
            channelExec = this.getExecChannel();
            channelExec.setCommand(string5);
            this.sendFile((Channel)channelExec, string, string3, string4);
            channelExec.disconnect();
        }
        catch (JSchException jSchException) {
            if (channelExec != null) {
                channelExec.disconnect();
            }
            throw (IOException)new IOException("Error during SCP transfer." + jSchException.getMessage()).initCause(jSchException);
        }
    }

    public void get(String string, String string2) throws IOException, RemoteScpException {
        File file = new File(string2);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.get(string, fileOutputStream);
    }

    public void get(String string, OutputStream outputStream) throws IOException, RemoteScpException {
        ChannelExec channelExec = null;
        if (string == null || outputStream == null) {
            throw new IllegalArgumentException("Null argument.");
        }
        String string2 = "scp -p -f " + string;
        try {
            channelExec = this.getExecChannel();
            channelExec.setCommand(string2);
            this.receiveStream((Channel)channelExec, string, outputStream);
            channelExec.disconnect();
        }
        catch (JSchException jSchException) {
            if (channelExec != null) {
                channelExec.disconnect();
            }
            throw (IOException)new IOException("Error during SCP transfer." + jSchException.getMessage()).initCause(jSchException);
        }
    }

    public FileInfo getFileinfo(String string) throws IOException, RemoteScpException {
        ChannelExec channelExec = null;
        FileInfo fileInfo = null;
        if (string == null) {
            throw new IllegalArgumentException("Null argument.");
        }
        String string2 = "scp -p -f \"" + string + "\"";
        try {
            channelExec = this.getExecChannel();
            channelExec.setCommand(string2);
            fileInfo = this.receiveStream((Channel)channelExec, string, null);
            channelExec.disconnect();
        }
        catch (JSchException jSchException) {
            throw (IOException)new IOException("Error during SCP transfer." + jSchException.getMessage()).initCause(jSchException);
        }
        finally {
            if (channelExec != null) {
                channelExec.disconnect();
            }
        }
        return fileInfo;
    }

    public class FileInfo {
        private String filename;
        private long length;
        private long lastModified;

        public void setFilename(String string) {
            this.filename = string;
        }

        public String getFilename() {
            return this.filename;
        }

        public void setLength(long l) {
            this.length = l;
        }

        public long getLength() {
            return this.length;
        }

        public void setLastModified(long l) {
            this.lastModified = l;
        }

        public long getLastModified() {
            return this.lastModified;
        }
    }
}

