/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files;

import com.swoval.concurrent.ThreadFactory;
import java.util.ArrayList;
import java.util.PriorityQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

abstract class Executor
implements AutoCloseable {
    private static final PriorityRunnable STOP = new PriorityRunnable(new Runnable(){

        @Override
        public void run() {
        }
    }, -1);

    Executor() {
    }

    void run(Runnable runnable) {
        this.run(runnable, Integer.MAX_VALUE);
    }

    abstract void run(Runnable var1, int var2);

    @Override
    public void close() {
    }

    static Executor make(String string) {
        ThreadFactory threadFactory = new ThreadFactory(string);
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, (BlockingQueue)new LinkedBlockingQueue(), (java.util.concurrent.ThreadFactory)threadFactory){

            @Override
            protected void afterExecute(Runnable runnable, Throwable throwable) {
                super.afterExecute(runnable, throwable);
                if (throwable != null) {
                    System.err.println("Error running: " + runnable + "\n" + throwable);
                    throwable.printStackTrace(System.err);
                }
            }
        };
        return new ExecutorImpl(threadFactory, threadPoolExecutor);
    }

    private static final class PriorityRunnable
    implements Runnable,
    Comparable<PriorityRunnable> {
        private final Runnable runnable;
        private final int priority;

        PriorityRunnable(Runnable runnable, int n) {
            this.runnable = runnable;
            this.priority = n < 0 ? n : 0;
        }

        @Override
        public int compareTo(PriorityRunnable priorityRunnable) {
            return Integer.compare(this.priority, priorityRunnable.priority);
        }

        @Override
        public void run() {
            this.runnable.run();
        }
    }

    static class ExecutorImpl
    extends Executor {
        private final AtomicBoolean closed = new AtomicBoolean(false);
        final ThreadFactory factory;
        final ExecutorService service;
        final LinkedBlockingQueue<PriorityRunnable> consumers = new LinkedBlockingQueue();

        ExecutorImpl(ThreadFactory threadFactory, ExecutorService executorService) {
            this.factory = threadFactory;
            this.service = executorService;
            executorService.submit(new Runnable(){

                @Override
                public void run() {
                    boolean bl = false;
                    while (!(bl || ExecutorImpl.this.closed.get() || Thread.currentThread().isInterrupted())) {
                        try {
                            PriorityQueue<PriorityRunnable> priorityQueue = new PriorityQueue<PriorityRunnable>();
                            priorityQueue.add(ExecutorImpl.this.consumers.take());
                            ExecutorImpl.this.drainRunnables(priorityQueue);
                            while (priorityQueue.peek() != null && !bl) {
                                ExecutorImpl.this.drainRunnables(priorityQueue);
                                PriorityRunnable priorityRunnable = (PriorityRunnable)priorityQueue.poll();
                                assert (priorityRunnable != null);
                                bl = priorityRunnable.priority < 0;
                                try {
                                    priorityRunnable.run();
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            bl = true;
                        }
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (this.closed.compareAndSet(false, true)) {
                super.close();
                LinkedBlockingQueue<PriorityRunnable> linkedBlockingQueue = this.consumers;
                synchronized (linkedBlockingQueue) {
                    this.consumers.clear();
                    this.consumers.offer(STOP);
                }
                this.service.shutdownNow();
                try {
                    if (!this.service.awaitTermination(5L, TimeUnit.SECONDS)) {
                        System.err.println("Couldn't close executor");
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void run(Runnable runnable, int n) {
            if (this.closed.get()) {
                new Exception("Tried to submit to closed executor").printStackTrace(System.err);
            } else {
                LinkedBlockingQueue<PriorityRunnable> linkedBlockingQueue = this.consumers;
                synchronized (linkedBlockingQueue) {
                    if (!this.consumers.offer(new PriorityRunnable(runnable, n))) {
                        throw new IllegalStateException("Couldn't run task due to full queue (" + this.consumers.size() + ")");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drainRunnables(PriorityQueue<PriorityRunnable> priorityQueue) {
            LinkedBlockingQueue<PriorityRunnable> linkedBlockingQueue = this.consumers;
            synchronized (linkedBlockingQueue) {
                if (this.consumers.size() > 0) {
                    ArrayList arrayList = new ArrayList();
                    this.consumers.drainTo(arrayList);
                    priorityQueue.addAll(arrayList);
                }
            }
        }
    }
}

