/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files;

import com.swoval.files.DirectoryLister;
import com.swoval.files.SimpleFileTreeView;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

class NioDirectoryLister
implements DirectoryLister {
    NioDirectoryLister() {
    }

    @Override
    public SimpleFileTreeView.ListResults apply(final String string, boolean bl) throws IOException {
        final Path path = Paths.get(string, new String[0]);
        final SimpleFileTreeView.ListResults listResults = new SimpleFileTreeView.ListResults();
        HashSet<FileVisitOption> hashSet = new HashSet<FileVisitOption>();
        final AtomicReference atomicReference = new AtomicReference();
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        Files.walkFileTree(path, hashSet, 1, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path path2, BasicFileAttributes basicFileAttributes) {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path path2, BasicFileAttributes basicFileAttributes) throws IOException {
                if (basicFileAttributes.isSymbolicLink()) {
                    if (path2.equals(path)) {
                        atomicBoolean.set(true);
                    } else {
                        listResults.addSymlink(path2.getFileName().toString());
                    }
                } else if (basicFileAttributes.isDirectory()) {
                    listResults.addDir(path2.getFileName().toString());
                } else {
                    if (path2.equals(path)) {
                        throw new NotDirectoryException(string);
                    }
                    listResults.addFile(path2.getFileName().toString());
                }
                return atomicBoolean.get() ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path path2, IOException iOException) {
                atomicReference.set(iOException);
                return FileVisitResult.TERMINATE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path path2, IOException iOException) {
                return FileVisitResult.CONTINUE;
            }
        });
        IOException iOException = (IOException)atomicReference.get();
        if (iOException instanceof FileSystemException) {
            FileSystemException fileSystemException = (FileSystemException)iOException;
            if (iOException.getMessage().contains("Not a directory")) {
                throw new NotDirectoryException(fileSystemException.getFile());
            }
            throw fileSystemException;
        }
        if (iOException != null) {
            throw iOException;
        }
        if (atomicBoolean.get()) {
            return this.apply(path.toRealPath(new LinkOption[0]).toString(), bl);
        }
        return listResults;
    }
}

