/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.AwtGraphicsConfigData;
import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class AwtScreenData
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return 48;
    }

    @Override
    public int getDataSize() {
        return AwtScreenData.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public AwtScreenData(long addr) {
        log.finest("Creating");
        this.pData = addr;
        this.should_free_memory = false;
    }

    public AwtScreenData() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(AwtScreenData.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public int get_numConfigs() {
        log.finest("");
        return Native.getInt(this.pData + 0L);
    }

    public void set_numConfigs(int v) {
        log.finest("");
        Native.putInt(this.pData + 0L, v);
    }

    public long get_root() {
        log.finest("");
        return Native.getLong(this.pData + 8L);
    }

    public void set_root(long v) {
        log.finest("");
        Native.putLong(this.pData + 8L, v);
    }

    public long get_whitepixel() {
        log.finest("");
        return Native.getLong(this.pData + 16L);
    }

    public void set_whitepixel(long v) {
        log.finest("");
        Native.putLong(this.pData + 16L, v);
    }

    public long get_blackpixel() {
        log.finest("");
        return Native.getLong(this.pData + 24L);
    }

    public void set_blackpixel(long v) {
        log.finest("");
        Native.putLong(this.pData + 24L, v);
    }

    public AwtGraphicsConfigData get_defaultConfig(int index) {
        log.finest("");
        return Native.getLong(this.pData + 32L) != 0L ? new AwtGraphicsConfigData(Native.getLong(this.pData + 32L) + (long)(index * 208)) : null;
    }

    public long get_defaultConfig() {
        log.finest("");
        return Native.getLong(this.pData + 32L);
    }

    public void set_defaultConfig(long v) {
        log.finest("");
        Native.putLong(this.pData + 32L, v);
    }

    public long get_configs(int index) {
        log.finest("");
        return Native.getLong(this.pData + 40L) + (long)(index * Native.getLongSize());
    }

    public long get_configs() {
        log.finest("");
        return Native.getLong(this.pData + 40L);
    }

    public void set_configs(long v) {
        log.finest("");
        Native.putLong(this.pData + 40L, v);
    }

    @Override
    String getName() {
        return "AwtScreenData";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder ret = new StringBuilder(240);
        ret.append("numConfigs = ").append(this.get_numConfigs()).append(", ");
        ret.append("root = ").append(this.get_root()).append(", ");
        ret.append("whitepixel = ").append(this.get_whitepixel()).append(", ");
        ret.append("blackpixel = ").append(this.get_blackpixel()).append(", ");
        ret.append("defaultConfig = ").append(this.get_defaultConfig()).append(", ");
        ret.append("configs = ").append(this.get_configs()).append(", ");
        return ret.toString();
    }
}

