/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.expression;

import javax.annotation.Nonnull;
import org.semanticweb.owlapi.expression.OWLEntityChecker;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.util.BidirectionalShortFormProvider;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class ShortFormEntityChecker
implements OWLEntityChecker {
    @Nonnull
    private final BidirectionalShortFormProvider shortFormProvider;

    public ShortFormEntityChecker(@Nonnull BidirectionalShortFormProvider shortFormProvider) {
        this.shortFormProvider = OWLAPIPreconditions.checkNotNull(shortFormProvider, "shortFormProvider cannot be null");
    }

    @Override
    public OWLClass getOWLClass(String name) {
        for (OWLEntity ent : this.shortFormProvider.getEntities(OWLAPIPreconditions.checkNotNull(name, "name cannot be null"))) {
            if (!ent.isOWLClass()) continue;
            return ent.asOWLClass();
        }
        return null;
    }

    @Override
    public OWLDataProperty getOWLDataProperty(String name) {
        for (OWLEntity ent : this.shortFormProvider.getEntities(OWLAPIPreconditions.checkNotNull(name, "name cannot be null"))) {
            if (!ent.isOWLDataProperty()) continue;
            return ent.asOWLDataProperty();
        }
        return null;
    }

    @Override
    public OWLDatatype getOWLDatatype(String name) {
        for (OWLEntity ent : this.shortFormProvider.getEntities(OWLAPIPreconditions.checkNotNull(name, "name cannot be null"))) {
            if (!ent.isOWLDatatype()) continue;
            return ent.asOWLDatatype();
        }
        return null;
    }

    @Override
    public OWLNamedIndividual getOWLIndividual(String name) {
        for (OWLEntity ent : this.shortFormProvider.getEntities(OWLAPIPreconditions.checkNotNull(name, "name cannot be null"))) {
            if (!ent.isOWLNamedIndividual()) continue;
            return ent.asOWLNamedIndividual();
        }
        return null;
    }

    @Override
    public OWLObjectProperty getOWLObjectProperty(String name) {
        for (OWLEntity ent : this.shortFormProvider.getEntities(OWLAPIPreconditions.checkNotNull(name, "name cannot be null"))) {
            if (!ent.isOWLObjectProperty()) continue;
            return ent.asOWLObjectProperty();
        }
        return null;
    }

    @Override
    public OWLAnnotationProperty getOWLAnnotationProperty(String name) {
        for (OWLEntity ent : this.shortFormProvider.getEntities(OWLAPIPreconditions.checkNotNull(name, "name cannot be null"))) {
            if (!ent.isOWLAnnotationProperty()) continue;
            return ent.asOWLAnnotationProperty();
        }
        return null;
    }
}

