/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.hierarchy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.protege.editor.owl.model.hierarchy.AbstractOWLPropertyHierarchyProvider;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSubPropertyAxiom;
import org.semanticweb.owlapi.search.EntitySearcher;

public class OWLDataPropertyHierarchyProvider
extends AbstractOWLPropertyHierarchyProvider<OWLDataRange, OWLDataPropertyExpression, OWLDataProperty> {
    public OWLDataPropertyHierarchyProvider(OWLOntologyManager owlOntologyManager) {
        super(owlOntologyManager);
    }

    @Override
    protected Set<OWLDataProperty> getPropertiesReferencedInChange(List<? extends OWLOntologyChange> changes) {
        HashSet<OWLDataProperty> result = new HashSet<OWLDataProperty>();
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!oWLOntologyChange.isAxiomChange()) continue;
            for (OWLEntity entity : oWLOntologyChange.getSignature()) {
                if (!entity.isOWLDataProperty()) continue;
                result.add(entity.asOWLDataProperty());
            }
        }
        return result;
    }

    @Override
    protected Set<? extends OWLDataProperty> getReferencedProperties(OWLOntology ont) {
        return ont.getDataPropertiesInSignature();
    }

    @Override
    protected boolean containsReference(OWLOntology ont, OWLDataProperty prop) {
        return ont.containsDataPropertyInSignature(prop.getIRI());
    }

    @Override
    protected Set<? extends OWLSubPropertyAxiom<OWLDataPropertyExpression>> getSubPropertyAxiomForRHS(OWLDataProperty prop, OWLOntology ont) {
        return ont.getDataSubPropertyAxiomsForSuperProperty((OWLDataPropertyExpression)prop);
    }

    @Override
    protected OWLDataProperty getRoot() {
        return this.getManager().getOWLDataFactory().getOWLTopDataProperty();
    }

    @Override
    protected Collection<OWLDataProperty> getSuperProperties(OWLDataProperty subProperty, Set<OWLOntology> ontologies) {
        return EntitySearcher.getSuperProperties((OWLDataPropertyExpression)subProperty, ontologies).stream().filter(p -> !p.isAnonymous()).map(p -> (OWLDataProperty)p).collect(Collectors.toList());
    }

    @Override
    protected Collection<OWLDataProperty> getSubProperties(OWLDataProperty superProp, Set<OWLOntology> ontologies) {
        ArrayList<OWLDataProperty> result = new ArrayList<OWLDataProperty>();
        for (OWLOntology ont : ontologies) {
            ont.getDataSubPropertyAxiomsForSuperProperty((OWLDataPropertyExpression)superProp).stream().map(OWLSubPropertyAxiom::getSubProperty).filter(p -> !p.isAnonymous()).map(p -> (OWLDataProperty)p).forEach(result::add);
        }
        return result;
    }
}

