/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.plaf.ComponentUI;

public class LayerUI<V extends Component>
extends ComponentUI
implements Serializable {
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    @Override
    public void paint(Graphics g, JComponent c) {
        c.paint(g);
    }

    public void eventDispatched(AWTEvent e, JLayer<? extends V> l) {
        if (e instanceof FocusEvent) {
            this.processFocusEvent((FocusEvent)e, l);
        } else if (e instanceof MouseEvent) {
            switch (e.getID()) {
                case 500: 
                case 501: 
                case 502: 
                case 504: 
                case 505: {
                    this.processMouseEvent((MouseEvent)e, l);
                    break;
                }
                case 503: 
                case 506: {
                    this.processMouseMotionEvent((MouseEvent)e, l);
                    break;
                }
                case 507: {
                    this.processMouseWheelEvent((MouseWheelEvent)e, l);
                }
            }
        } else if (e instanceof KeyEvent) {
            this.processKeyEvent((KeyEvent)e, l);
        } else if (e instanceof ComponentEvent) {
            this.processComponentEvent((ComponentEvent)e, l);
        } else if (e instanceof InputMethodEvent) {
            this.processInputMethodEvent((InputMethodEvent)e, l);
        } else if (e instanceof HierarchyEvent) {
            switch (e.getID()) {
                case 1400: {
                    this.processHierarchyEvent((HierarchyEvent)e, l);
                    break;
                }
                case 1401: 
                case 1402: {
                    this.processHierarchyBoundsEvent((HierarchyEvent)e, l);
                }
            }
        }
    }

    protected void processComponentEvent(ComponentEvent e, JLayer<? extends V> l) {
    }

    protected void processFocusEvent(FocusEvent e, JLayer<? extends V> l) {
    }

    protected void processKeyEvent(KeyEvent e, JLayer<? extends V> l) {
    }

    protected void processMouseEvent(MouseEvent e, JLayer<? extends V> l) {
    }

    protected void processMouseMotionEvent(MouseEvent e, JLayer<? extends V> l) {
    }

    protected void processMouseWheelEvent(MouseWheelEvent e, JLayer<? extends V> l) {
    }

    protected void processInputMethodEvent(InputMethodEvent e, JLayer<? extends V> l) {
    }

    protected void processHierarchyEvent(HierarchyEvent e, JLayer<? extends V> l) {
    }

    protected void processHierarchyBoundsEvent(HierarchyEvent e, JLayer<? extends V> l) {
    }

    public void updateUI(JLayer<? extends V> l) {
    }

    @Override
    public void installUI(JComponent c) {
        this.addPropertyChangeListener((JLayer)c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.removePropertyChangeListener((JLayer)c);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.propertyChangeSupport.getPropertyChangeListeners();
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.propertyChangeSupport.getPropertyChangeListeners(propertyName);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void applyPropertyChange(PropertyChangeEvent evt, JLayer<? extends V> l) {
    }

    @Override
    public int getBaseline(JComponent c, int width, int height) {
        JLayer l = (JLayer)c;
        if (l.getView() != null) {
            return ((Component)l.getView()).getBaseline(width, height);
        }
        return super.getBaseline(c, width, height);
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(JComponent c) {
        JLayer l = (JLayer)c;
        if (l.getView() != null) {
            return ((Component)l.getView()).getBaselineResizeBehavior();
        }
        return super.getBaselineResizeBehavior(c);
    }

    public void doLayout(JLayer<? extends V> l) {
        JPanel glassPane;
        V view = l.getView();
        if (view != null) {
            ((Component)view).setBounds(0, 0, l.getWidth(), l.getHeight());
        }
        if ((glassPane = l.getGlassPane()) != null) {
            glassPane.setBounds(0, 0, l.getWidth(), l.getHeight());
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        JLayer l = (JLayer)c;
        Object view = l.getView();
        if (view != null) {
            return ((Component)view).getPreferredSize();
        }
        return super.getPreferredSize(c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        JLayer l = (JLayer)c;
        Object view = l.getView();
        if (view != null) {
            return ((Component)view).getMinimumSize();
        }
        return super.getMinimumSize(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        JLayer l = (JLayer)c;
        Object view = l.getView();
        if (view != null) {
            return ((Component)view).getMaximumSize();
        }
        return super.getMaximumSize(c);
    }

    public void paintImmediately(int x, int y, int width, int height, JLayer<? extends V> l) {
        l.paintImmediately(x, y, width, height);
    }
}

