/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import mediathek.config.Daten;
import mediathek.config.Icons;
import mediathek.config.MVColor;
import mediathek.config.MVConfig;
import mediathek.filmlisten.FilmeLaden;
import mediathek.gui.messages.FilmListImportTypeChangedEvent;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.FilmListUpdateType;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.Log;
import mediathek.tool.TextCopyPasteHandler;
import net.engio.mbassy.listener.Handler;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.SystemUtils;

public class PanelFilmlisteLaden
extends JPanel {
    private final Daten daten;
    private JTextArea jTextAreaAuto;
    private JButton jButtonLoad;
    private JTextField jTextFieldUrl;
    private JButton jButtonDateiAuswaehlen;
    private JButton jButtonFilmeLaden;
    private JTextArea jTextAreaManuell;
    private JCheckBox jCheckBoxUpdate;
    private JRadioButton jRadioButtonAuto;
    private JRadioButton jRadioButtonManuell;
    private JCheckBox cbSign;
    private JCheckBox cbTrailer;
    private JCheckBox cbAudio;

    public PanelFilmlisteLaden(Daten d) {
        this.daten = d;
        this.daten.getMessageBus().subscribe(this);
        this.initComponents();
        this.init();
        Configuration config = ApplicationConfiguration.getConfiguration();
        this.cbSign.setSelected(config.getBoolean("filmlist.load.sign_language", true));
        this.cbSign.addActionListener(e -> config.setProperty("filmlist.load.sign_language", this.cbSign.isSelected()));
        this.cbAudio.setSelected(config.getBoolean("filmlist.load.audio_description", true));
        this.cbAudio.addActionListener(e -> config.setProperty("filmlist.load.audio_description", this.cbAudio.isSelected()));
        this.cbTrailer.setSelected(config.getBoolean("filmlist.load.trailer", true));
        this.cbTrailer.addActionListener(e -> config.setProperty("filmlist.load.trailer", this.cbTrailer.isSelected()));
    }

    private void init() {
        this.initRadio();
        FilmeLaden filmeLaden = this.daten.getFilmeLaden();
        this.jButtonLoad.addActionListener(ae -> filmeLaden.loadFilmlist(""));
        this.jButtonDateiAuswaehlen.setIcon(Icons.ICON_BUTTON_FILE_OPEN);
        this.jButtonDateiAuswaehlen.addActionListener(new BeobPfad());
        this.jButtonFilmeLaden.addActionListener(e -> {
            if (this.jCheckBoxUpdate.isSelected()) {
                filmeLaden.updateFilmlist(this.jTextFieldUrl.getText());
            } else {
                filmeLaden.loadFilmlist(this.jTextFieldUrl.getText());
            }
        });
        this.jRadioButtonManuell.addActionListener(new BeobOption());
        this.jRadioButtonAuto.addActionListener(new BeobOption());
        this.jTextFieldUrl.getDocument().addDocumentListener(new BeobDateiUrl());
        TextCopyPasteHandler<JTextField> handler = new TextCopyPasteHandler<JTextField>(this.jTextFieldUrl);
        this.jTextFieldUrl.setComponentPopupMenu(handler.getPopupMenu());
    }

    @Handler
    private void handleFilmListImportTypeChanged(FilmListImportTypeChangedEvent e) {
        SwingUtilities.invokeLater(this::initRadio);
    }

    private void initRadio() {
        switch (GuiFunktionen.getImportArtFilme()) {
            case MANUAL: {
                this.jRadioButtonManuell.setSelected(true);
                break;
            }
            case AUTOMATIC: {
                this.jRadioButtonAuto.setSelected(true);
            }
        }
        this.jTextFieldUrl.setText(MVConfig.get(MVConfig.Configs.SYSTEM_IMPORT_URL_MANUELL));
        this.setPanelTabelle(this.jRadioButtonManuell.isSelected());
    }

    private void setPanelTabelle(boolean manuell) {
        if (manuell) {
            this.jTextAreaManuell.setBackground(MVColor.FILMLISTE_LADEN_AKTIV.color);
            this.jTextAreaAuto.setBackground(null);
        } else {
            this.jTextAreaManuell.setBackground(null);
            this.jTextAreaAuto.setBackground(MVColor.FILMLISTE_LADEN_AKTIV.color);
        }
    }

    private void initComponents() {
        JPanel jPanelAuto = new JPanel();
        this.jTextAreaAuto = new JTextArea();
        this.jButtonLoad = new JButton();
        JPanel jPanelManuel = new JPanel();
        JLabel jLabel1 = new JLabel();
        this.jTextFieldUrl = new JTextField();
        this.jButtonDateiAuswaehlen = new JButton();
        this.jButtonFilmeLaden = new JButton();
        this.jTextAreaManuell = new JTextArea();
        this.jCheckBoxUpdate = new JCheckBox();
        this.jRadioButtonAuto = new JRadioButton();
        this.jRadioButtonManuell = new JRadioButton();
        JPanel jPanel1 = new JPanel();
        this.cbSign = new JCheckBox();
        this.cbTrailer = new JCheckBox();
        this.cbAudio = new JCheckBox();
        this.setMinimumSize(new Dimension(746, 400));
        this.setPreferredSize(new Dimension(746, 400));
        this.setLayout(new MigLayout(new LC().insets("5").hideMode(3).gridGap("5", "5"), new AC().fill().gap().grow().fill(), new AC().fill().gap().fill().gap().fill()));
        jPanelAuto.setBorder(new TitledBorder("Die Filmliste automatisch laden"));
        jPanelAuto.setLayout(new MigLayout(new LC().insets("5").hideMode(3).gridGap("5", "5"), new AC().grow().fill().gap().grow().fill(), new AC().fill().gap().fill()));
        this.jTextAreaAuto.setEditable(false);
        this.jTextAreaAuto.setColumns(20);
        this.jTextAreaAuto.setRows(3);
        this.jTextAreaAuto.setText("Die Filmliste wird beim Programmstart automatisch geladen (wenn sie \u00e4lter als 3h ist). Zus\u00e4tzlich kann sie \u00fcber den Button \"Neue Filmliste laden\" aktualisiert werden. Zum Update werden dann nur noch die Differenzlisten geladen (enthalten nur die neuen Filme).");
        this.jTextAreaAuto.setMargin(new Insets(4, 4, 4, 4));
        this.jTextAreaAuto.setWrapStyleWord(true);
        this.jTextAreaAuto.setLineWrap(true);
        this.jTextAreaAuto.setFont(this.jTextAreaAuto.getFont().deriveFont((float)this.jTextAreaAuto.getFont().getSize() - 1.0f));
        jPanelAuto.add((Component)this.jTextAreaAuto, new CC().cell(0, 0, 2, 1));
        this.jButtonLoad.setText("Filme jetzt laden");
        jPanelAuto.add((Component)this.jButtonLoad, new CC().cell(1, 1).alignX("trailing").growX(0.0f));
        this.add((Component)jPanelAuto, new CC().cell(1, 0));
        jPanelManuel.setBorder(new TitledBorder("Filmliste nur manuell laden"));
        jPanelManuel.setLayout(new MigLayout(new LC().insets("5").hideMode(3).gridGap("5", "5"), new AC().fill().gap().grow().fill().gap().fill().gap().fill(), new AC().fill().gap().fill().gap().fill()));
        jLabel1.setText("URL/Datei:");
        jPanelManuel.add((Component)jLabel1, new CC().cell(0, 1));
        jPanelManuel.add((Component)this.jTextFieldUrl, new CC().cell(1, 1, 2, 1));
        this.jButtonDateiAuswaehlen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-file-open.png")));
        this.jButtonDateiAuswaehlen.setToolTipText("URL oder lokale Filmliste ausw\u00e4hlen");
        jPanelManuel.add((Component)this.jButtonDateiAuswaehlen, new CC().cell(3, 1).alignX("left").growX(0.0f).width("32:32:32").height("32:32:32"));
        this.jButtonFilmeLaden.setText("Filme jetzt laden");
        jPanelManuel.add((Component)this.jButtonFilmeLaden, new CC().cell(2, 2, 2, 1));
        this.jTextAreaManuell.setEditable(false);
        this.jTextAreaManuell.setColumns(20);
        this.jTextAreaManuell.setRows(2);
        this.jTextAreaManuell.setText("Die Filmliste wird nur manuell \u00fcber den Button \"Neue Filmliste laden\" geladen. Es wird dann dieser Dialog angezeigt und es kann eine URL/Datei zum Laden angegeben werden.");
        this.jTextAreaManuell.setMargin(new Insets(4, 4, 4, 4));
        this.jTextAreaManuell.setWrapStyleWord(true);
        this.jTextAreaManuell.setLineWrap(true);
        this.jTextAreaManuell.setFont(this.jTextAreaManuell.getFont().deriveFont((float)this.jTextAreaManuell.getFont().getSize() - 1.0f));
        jPanelManuel.add((Component)this.jTextAreaManuell, new CC().cell(0, 0, 4, 1));
        this.jCheckBoxUpdate.setText("alte Filmliste nicht l\u00f6schen, nur erweitern");
        jPanelManuel.add((Component)this.jCheckBoxUpdate, new CC().cell(0, 2, 2, 1));
        this.add((Component)jPanelManuel, new CC().cell(1, 1));
        this.add((Component)this.jRadioButtonAuto, new CC().cell(0, 0).alignY("top").growY(0.0f));
        this.add((Component)this.jRadioButtonManuell, new CC().cell(0, 1).alignY("top").growY(0.0f));
        jPanel1.setBorder(new TitledBorder("Zus\u00e4tzliche Filmdaten laden"));
        jPanel1.setToolTipText("<html>Alle nicht angew\u00e4hlten Eintr\u00e4ge werden beim Laden der Filmliste aus dem Endergebnis herausgefiltert.<br/><b>Die Eintr\u00e4ge werden dauerhaft aus der lokalen Filmliste entfernt.</b><br/>Sie werden erst wieder beim Laden einer neuen Liste vom Server hinzugef\u00fcgt wenn die Einstellungen entsprechend angepasst wurden.</html>");
        jPanel1.setLayout(new MigLayout(new LC().insets("5").hideMode(3).gridGap("5", "5"), new AC().fill().gap().fill().gap().fill(), new AC().fill()));
        this.cbSign.setText("Geb\u00e4rdensprache");
        jPanel1.add((Component)this.cbSign, new CC().cell(2, 0));
        this.cbTrailer.setText("Trailer/Teaser/Vorschau");
        jPanel1.add((Component)this.cbTrailer, new CC().cell(0, 0));
        this.cbAudio.setText("H\u00f6rfassungen");
        jPanel1.add((Component)this.cbAudio, new CC().cell(1, 0));
        this.add((Component)jPanel1, new CC().cell(1, 2));
        ButtonGroup buttonGroup1 = new ButtonGroup();
        buttonGroup1.add(this.jRadioButtonAuto);
        buttonGroup1.add(this.jRadioButtonManuell);
    }

    private class BeobPfad
    implements ActionListener {
        private BeobPfad() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SystemUtils.IS_OS_MAC_OSX) {
                FileDialog chooser = new FileDialog((Frame)MediathekGui.ui(), "Filmliste laden");
                chooser.setMode(0);
                chooser.setVisible(true);
                if (chooser.getFile() != null) {
                    try {
                        File destination = new File(chooser.getDirectory() + chooser.getFile());
                        PanelFilmlisteLaden.this.jTextFieldUrl.setText(destination.getAbsolutePath());
                    }
                    catch (Exception ex) {
                        Log.errorLog(102036579, ex);
                    }
                }
            } else {
                JFileChooser chooser = new JFileChooser();
                if (!PanelFilmlisteLaden.this.jTextFieldUrl.getText().isEmpty()) {
                    chooser.setCurrentDirectory(new File(PanelFilmlisteLaden.this.jTextFieldUrl.getText()));
                }
                chooser.setFileSelectionMode(0);
                chooser.setFileHidingEnabled(false);
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    try {
                        PanelFilmlisteLaden.this.jTextFieldUrl.setText(chooser.getSelectedFile().getAbsolutePath());
                    }
                    catch (Exception ex) {
                        Log.errorLog(733025319, ex);
                    }
                }
            }
        }
    }

    private class BeobOption
    implements ActionListener {
        private BeobOption() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PanelFilmlisteLaden.this.jRadioButtonManuell.isSelected()) {
                GuiFunktionen.setImportArtFilme(FilmListUpdateType.MANUAL);
            } else {
                GuiFunktionen.setImportArtFilme(FilmListUpdateType.AUTOMATIC);
            }
            PanelFilmlisteLaden.this.daten.getMessageBus().publishAsync(new FilmListImportTypeChangedEvent());
        }
    }

    private class BeobDateiUrl
    implements DocumentListener {
        private BeobDateiUrl() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.turnOnManualImport();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.turnOnManualImport();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.turnOnManualImport();
        }

        private void turnOnManualImport() {
            MVConfig.add(MVConfig.Configs.SYSTEM_IMPORT_URL_MANUELL, PanelFilmlisteLaden.this.jTextFieldUrl.getText());
        }
    }
}

