/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.annotation;

import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationUtil;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.annotation.AnnotationValueResolver;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AnnotationValue<A extends Annotation>
implements AnnotationValueResolver {
    private final String annotationName;
    private final ConvertibleValues<Object> convertibleValues;
    private final Map<CharSequence, Object> values;
    private final Map<String, Object> defaultValues;
    private final Function<Object, Object> valueMapper;

    public AnnotationValue(String annotationName, Map<CharSequence, Object> values) {
        this.annotationName = annotationName;
        this.convertibleValues = this.newConvertibleValues(values);
        this.values = values;
        this.defaultValues = Collections.emptyMap();
        this.valueMapper = null;
    }

    public AnnotationValue(String annotationName, Map<CharSequence, Object> values, Map<String, Object> defaultValues) {
        this.annotationName = annotationName;
        this.convertibleValues = this.newConvertibleValues(values);
        this.values = values;
        this.defaultValues = defaultValues != null ? defaultValues : Collections.emptyMap();
        this.valueMapper = null;
    }

    public AnnotationValue(String annotationName) {
        this.annotationName = annotationName;
        this.convertibleValues = ConvertibleValues.EMPTY;
        this.values = Collections.emptyMap();
        this.defaultValues = Collections.emptyMap();
        this.valueMapper = null;
    }

    public AnnotationValue(String annotationName, ConvertibleValues<Object> convertibleValues) {
        this.annotationName = annotationName;
        this.convertibleValues = convertibleValues;
        Map<String, Object> existing = convertibleValues.asMap();
        this.values = new HashMap<CharSequence, Object>(existing.size());
        this.values.putAll(existing);
        this.defaultValues = Collections.emptyMap();
        this.valueMapper = null;
    }

    @Internal
    protected AnnotationValue(AnnotationValue<A> target, Map<String, Object> defaultValues, ConvertibleValues<Object> convertibleValues, Function<Object, Object> valueMapper) {
        this.annotationName = target.annotationName;
        this.defaultValues = defaultValues != null ? defaultValues : target.defaultValues;
        this.values = target.values;
        this.convertibleValues = convertibleValues;
        this.valueMapper = valueMapper;
    }

    @Nonnull
    public Map<String, String> getProperties(@Nonnull String member) {
        return this.getProperties(member, "name");
    }

    public Map<String, String> getProperties(@Nonnull String member, String keyMember) {
        List values;
        ArgumentUtils.requireNonNull("keyMember", keyMember);
        if (StringUtils.isNotEmpty(member) && CollectionUtils.isNotEmpty(values = this.getAnnotations(member))) {
            LinkedHashMap props = new LinkedHashMap(values.size());
            for (AnnotationValue av : values) {
                String name = av.stringValue(keyMember).orElse(null);
                if (!StringUtils.isNotEmpty(name)) continue;
                av.stringValue("value", this.valueMapper).ifPresent(v -> props.put(name, v));
            }
            return Collections.unmodifiableMap(props);
        }
        return Collections.emptyMap();
    }

    @Override
    public <E extends Enum> Optional<E> enumValue(@Nonnull String member, @Nonnull Class<E> enumType) {
        return this.enumValue(member, enumType, this.valueMapper);
    }

    public <E extends Enum> Optional<E> enumValue(@Nonnull String member, @Nonnull Class<E> enumType, Function<Object, Object> valueMapper) {
        Object o;
        ArgumentUtils.requireNonNull("enumType", enumType);
        if (StringUtils.isNotEmpty(member) && (o = this.getRawSingleValue(member, valueMapper)) != null) {
            if (enumType.isInstance(o)) {
                return Optional.of((Enum)o);
            }
            try {
                E e = Enum.valueOf(enumType, o.toString());
                return Optional.of(e);
            }
            catch (IllegalArgumentException ex) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    @Override
    @Nonnull
    public Optional<Class<?>> classValue() {
        return this.classValue("value");
    }

    @Override
    public Optional<Class<?>> classValue(@Nonnull String member) {
        return this.classValue(member, this.valueMapper);
    }

    @Override
    public <T> Optional<Class<? extends T>> classValue(@Nonnull String member, @Nonnull Class<T> requiredType) {
        ArgumentUtils.requireNonNull("requiredType", requiredType);
        if (StringUtils.isNotEmpty(member)) {
            Class t;
            Object o = this.getRawSingleValue(member, this.valueMapper);
            if (o instanceof AnnotationClassValue) {
                Class t2 = ((AnnotationClassValue)o).getType().orElse(null);
                if (t2 != null && requiredType.isAssignableFrom(t2)) {
                    return Optional.of(t2);
                }
                return Optional.empty();
            }
            if (o instanceof Class) {
                Class t3 = (Class)o;
                if (requiredType.isAssignableFrom(t3)) {
                    return Optional.of(t3);
                }
                return Optional.empty();
            }
            if (o != null && (t = (Class)ClassUtils.forName(o.toString(), this.getClass().getClassLoader()).orElse(null)) != null && requiredType.isAssignableFrom(t)) {
                return Optional.of(t);
            }
        }
        return Optional.empty();
    }

    public Optional<Class<?>> classValue(@Nonnull String member, @Nullable Function<Object, Object> valueMapper) {
        if (StringUtils.isNotEmpty(member)) {
            Object o = this.getRawSingleValue(member, valueMapper);
            if (o instanceof AnnotationClassValue) {
                return ((AnnotationClassValue)o).getType();
            }
            if (o instanceof Class) {
                return Optional.of((Class)o);
            }
        }
        return Optional.empty();
    }

    @Override
    @Nonnull
    public String[] stringValues(@Nonnull String member) {
        Function<Object, Object> valueMapper = this.valueMapper;
        return this.stringValues(member, valueMapper);
    }

    public String[] stringValues(@Nonnull String member, Function<Object, Object> valueMapper) {
        Object o;
        String[] strs;
        if (StringUtils.isNotEmpty(member) && (strs = AnnotationValue.resolveStringValues(o = this.values.get(member), valueMapper)) != null) {
            return strs;
        }
        return StringUtils.EMPTY_STRING_ARRAY;
    }

    @Override
    public Class<?>[] classValues(@Nonnull String member) {
        Object o;
        Class<?>[] type;
        if (StringUtils.isNotEmpty(member) && (type = AnnotationValue.resolveClassValues(o = this.values.get(member))) != null) {
            return type;
        }
        return ReflectionUtils.EMPTY_CLASS_ARRAY;
    }

    @Override
    public OptionalInt intValue(@Nonnull String member) {
        return this.intValue(member, this.valueMapper);
    }

    public OptionalInt intValue(@Nonnull String member, @Nullable Function<Object, Object> valueMapper) {
        if (StringUtils.isNotEmpty(member)) {
            Object o = this.getRawSingleValue(member, valueMapper);
            if (o instanceof Number) {
                return OptionalInt.of(((Number)o).intValue());
            }
            if (o instanceof CharSequence) {
                try {
                    return OptionalInt.of(Integer.parseInt(o.toString()));
                }
                catch (NumberFormatException e) {
                    return OptionalInt.empty();
                }
            }
        }
        return OptionalInt.empty();
    }

    @Override
    public OptionalInt intValue() {
        return this.intValue("value");
    }

    @Override
    public OptionalLong longValue(@Nonnull String member) {
        return this.longValue(member, null);
    }

    public OptionalLong longValue(@Nonnull String member, @Nullable Function<Object, Object> valueMapper) {
        if (StringUtils.isNotEmpty(member)) {
            Object o = this.getRawSingleValue(member, valueMapper);
            if (o instanceof Number) {
                return OptionalLong.of(((Number)o).longValue());
            }
            if (o instanceof CharSequence) {
                try {
                    return OptionalLong.of(Long.parseLong(o.toString()));
                }
                catch (NumberFormatException e) {
                    return OptionalLong.empty();
                }
            }
        }
        return OptionalLong.empty();
    }

    public Optional<Boolean> booleanValue(@Nonnull String member, @Nullable Function<Object, Object> valueMapper) {
        if (StringUtils.isNotEmpty(member)) {
            Object o = this.getRawSingleValue(member, valueMapper);
            if (o instanceof Boolean) {
                return Optional.of((Boolean)o);
            }
            if (o instanceof CharSequence) {
                return Optional.of(StringUtils.isTrue(o.toString()));
            }
        }
        return Optional.empty();
    }

    @Override
    public OptionalDouble doubleValue(@Nonnull String member) {
        return this.doubleValue(member, this.valueMapper);
    }

    public OptionalDouble doubleValue(@Nonnull String member, @Nullable Function<Object, Object> valueMapper) {
        if (StringUtils.isNotEmpty(member)) {
            Object o = this.getRawSingleValue(member, valueMapper);
            if (o instanceof Number) {
                return OptionalDouble.of(((Number)o).doubleValue());
            }
            if (o instanceof CharSequence) {
                try {
                    return OptionalDouble.of(Double.parseDouble(o.toString()));
                }
                catch (NumberFormatException e) {
                    return OptionalDouble.empty();
                }
            }
        }
        return OptionalDouble.empty();
    }

    @Override
    public OptionalDouble doubleValue() {
        return this.doubleValue("value");
    }

    @Override
    public Optional<String> stringValue(@Nonnull String member) {
        Object o;
        if (StringUtils.isNotEmpty(member) && (o = this.getRawSingleValue(member, this.valueMapper)) != null) {
            return Optional.of(o.toString());
        }
        return Optional.empty();
    }

    public Optional<String> stringValue(@Nonnull String member, @Nullable Function<Object, Object> valueMapper) {
        Object o;
        if (StringUtils.isNotEmpty(member) && (o = this.getRawSingleValue(member, valueMapper)) != null) {
            return Optional.of(o.toString());
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> stringValue() {
        return this.stringValue("value");
    }

    @Override
    public Optional<Boolean> booleanValue(@Nonnull String member) {
        return this.booleanValue(member, null);
    }

    @Override
    public final boolean isPresent(CharSequence member) {
        if (StringUtils.isNotEmpty(member)) {
            return this.values.containsKey(member);
        }
        return false;
    }

    @Override
    public boolean isTrue() {
        return this.isTrue("value");
    }

    @Override
    public boolean isTrue(String member) {
        return this.isTrue(member, this.valueMapper);
    }

    public boolean isTrue(@Nonnull String member, @Nullable Function<Object, Object> valueMapper) {
        if (StringUtils.isNotEmpty(member)) {
            Object o = this.getRawSingleValue(member, valueMapper);
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
            if (o != null) {
                return StringUtils.isTrue(o.toString());
            }
        }
        return false;
    }

    @Override
    public boolean isFalse() {
        return !this.isTrue("value");
    }

    @Override
    public boolean isFalse(String member) {
        return !this.isTrue(member);
    }

    @Nonnull
    public final String getAnnotationName() {
        return this.annotationName;
    }

    public final boolean contains(String member) {
        return this.isPresent(member);
    }

    @Nonnull
    public final Set<CharSequence> getMemberNames() {
        return this.values.keySet();
    }

    @Override
    @Nonnull
    public Map<CharSequence, Object> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    @Nonnull
    public ConvertibleValues<Object> getConvertibleValues() {
        return this.convertibleValues;
    }

    @Override
    public <T> Optional<T> get(CharSequence member, ArgumentConversionContext<T> conversionContext) {
        Object dv;
        Optional<T> result = this.convertibleValues.get(member, conversionContext);
        if (!result.isPresent() && (dv = this.defaultValues.get(member.toString())) != null) {
            return ConversionService.SHARED.convert(dv, conversionContext);
        }
        return result;
    }

    public <T> Optional<T> getValue(ArgumentConversionContext<T> conversionContext) {
        return this.get("value", conversionContext);
    }

    public final <T> Optional<T> getValue(Argument<T> argument) {
        return this.getValue(ConversionContext.of(argument));
    }

    public final <T> Optional<T> getValue(Class<T> type) {
        return this.getValue(ConversionContext.of(type));
    }

    @Nonnull
    public final <T> T getRequiredValue(Class<T> type) {
        return this.getRequiredValue("value", type);
    }

    @Nonnull
    public final <T> T getRequiredValue(String member, Class<T> type) {
        return this.get(member, ConversionContext.of(type)).orElseThrow(() -> new IllegalStateException("No value available for annotation member @" + this.annotationName + "[" + member + "] of type: " + type));
    }

    @Nonnull
    public final <T extends Annotation> List<AnnotationValue<T>> getAnnotations(String member, Class<T> type) {
        ArgumentUtils.requireNonNull("member", member);
        ArgumentUtils.requireNonNull("type", type);
        Object v = this.values.get(member);
        AnnotationValue[] values = null;
        if (v instanceof AnnotationValue) {
            values = new AnnotationValue[]{(AnnotationValue)v};
        } else if (v instanceof AnnotationValue[]) {
            values = (AnnotationValue[])v;
        }
        if (ArrayUtils.isNotEmpty(values)) {
            ArrayList<AnnotationValue<T>> list = new ArrayList<AnnotationValue<T>>(values.length);
            String typeName = type.getName();
            for (AnnotationValue value : values) {
                if (value == null || !value.getAnnotationName().equals(typeName)) continue;
                list.add(value);
            }
            return list;
        }
        return Collections.emptyList();
    }

    @Nonnull
    public final <T extends Annotation> List<AnnotationValue<T>> getAnnotations(String member) {
        ArgumentUtils.requireNonNull("member", member);
        Object v = this.values.get(member);
        if (v instanceof AnnotationValue) {
            return Collections.singletonList((AnnotationValue)v);
        }
        if (v instanceof AnnotationValue[]) {
            return Arrays.asList((AnnotationValue[])v);
        }
        return Collections.emptyList();
    }

    @Nonnull
    public final <T extends Annotation> Optional<AnnotationValue<T>> getAnnotation(String member, Class<T> type) {
        return this.getAnnotations(member, type).stream().findFirst();
    }

    public int hashCode() {
        return 31 * this.annotationName.hashCode() + AnnotationUtil.calculateHashCode(this.getValues());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!AnnotationValue.class.isInstance(obj)) {
            return false;
        }
        AnnotationValue other = (AnnotationValue)AnnotationValue.class.cast(obj);
        if (!this.annotationName.equals(other.getAnnotationName())) {
            return false;
        }
        Map<CharSequence, Object> otherValues = other.getValues();
        Map<CharSequence, Object> values = this.getValues();
        if (values.size() != otherValues.size()) {
            return false;
        }
        for (Map.Entry<CharSequence, Object> member : values.entrySet()) {
            Object otherValue;
            Object value = member.getValue();
            if (AnnotationUtil.areEqual(value, otherValue = otherValues.get(member.getKey()))) continue;
            return false;
        }
        return true;
    }

    public static <T extends Annotation> AnnotationValueBuilder<T> builder(String annotationName) {
        return new AnnotationValueBuilder(annotationName);
    }

    public static <T extends Annotation> AnnotationValueBuilder<T> builder(Class<T> annotation) {
        return new AnnotationValueBuilder(annotation);
    }

    @Internal
    @Nullable
    public static String[] resolveStringValues(@Nullable Object value, @Nullable Function<Object, Object> valueMapper) {
        if (value == null) {
            return null;
        }
        if (valueMapper != null) {
            value = valueMapper.apply(value);
        }
        if (value instanceof CharSequence) {
            return new String[]{value.toString()};
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        if (value != null) {
            if (value.getClass().isArray()) {
                int len = Array.getLength(value);
                String[] newArray = new String[len];
                for (int i = 0; i < newArray.length; ++i) {
                    Object entry = Array.get(value, i);
                    if (entry == null) continue;
                    newArray[i] = entry.toString();
                }
                return newArray;
            }
            return new String[]{value.toString()};
        }
        return null;
    }

    @Internal
    public static String[] resolveStringArray(String[] strs, @Nullable Function<Object, Object> valueMapper) {
        if (valueMapper != null) {
            String[] newStrs = new String[strs.length];
            for (int i = 0; i < strs.length; ++i) {
                String str = strs[i];
                newStrs[i] = valueMapper.apply(str).toString();
            }
            return newStrs;
        }
        return strs;
    }

    @Internal
    @Nullable
    public static Class<?>[] resolveClassValues(@Nullable Object value) {
        if (value instanceof AnnotationClassValue) {
            Class type = ((AnnotationClassValue)value).getType().orElse(null);
            if (type != null) {
                return new Class[]{type};
            }
        } else {
            if (value instanceof Object[]) {
                Object[] values = (Object[])value;
                if (values instanceof Class[]) {
                    return (Class[])values;
                }
                return (Class[])Arrays.stream(values).flatMap(o -> {
                    if (o instanceof AnnotationClassValue) {
                        Optional<Class<Class>> type = ((AnnotationClassValue)o).getType();
                        return type.map(Stream::of).orElse(Stream.empty());
                    }
                    if (o instanceof Class) {
                        return Stream.of((Class)o);
                    }
                    return Stream.empty();
                }).toArray(Class[]::new);
            }
            if (value instanceof Class) {
                return new Class[]{(Class)value};
            }
        }
        return null;
    }

    private ConvertibleValues<Object> newConvertibleValues(Map<CharSequence, Object> values) {
        if (CollectionUtils.isEmpty(values)) {
            return ConvertibleValues.EMPTY;
        }
        return ConvertibleValues.of(values);
    }

    @Nullable
    private Object getRawSingleValue(@Nonnull String member, Function<Object, Object> valueMapper) {
        Object rawValue = this.values.get(member);
        if (rawValue != null) {
            Iterator i;
            if (rawValue.getClass().isArray()) {
                int len = Array.getLength(rawValue);
                if (len > 0) {
                    rawValue = Array.get(rawValue, 0);
                }
            } else if (rawValue instanceof Iterable && (i = ((Iterable)rawValue).iterator()).hasNext()) {
                rawValue = i.next();
            }
        }
        if (valueMapper != null && rawValue instanceof String) {
            return valueMapper.apply(rawValue);
        }
        return rawValue;
    }
}

