/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.convert;

import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.convert.format.Format;
import io.micronaut.core.convert.format.FormattingTypeConverter;
import io.micronaut.core.convert.format.ReadableBytesTypeConverter;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.convert.value.ConvertibleValuesMap;
import io.micronaut.core.io.IOUtils;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ReferenceCounted;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.util.clhm.ConcurrentLinkedHashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.StringJoiner;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class DefaultConversionService
implements ConversionService<DefaultConversionService> {
    private static final int CACHE_MAX = 150;
    private static final TypeConverter UNCONVERTIBLE = (object, targetType, context) -> Optional.empty();
    private final Map<ConvertiblePair, TypeConverter> typeConverters = new ConcurrentHashMap<ConvertiblePair, TypeConverter>();
    private final Map<ConvertiblePair, TypeConverter> converterCache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(150L).build();

    public DefaultConversionService() {
        this.registerDefaultConverters();
    }

    @Override
    public <T> Optional<T> convert(Object object, Class<T> targetType, ConversionContext context) {
        if (object == null || targetType == null || context == null) {
            return Optional.empty();
        }
        if (targetType == Object.class) {
            return Optional.of(object);
        }
        Class<?> sourceType = object.getClass();
        Class clazz = targetType = targetType.isPrimitive() ? ReflectionUtils.getWrapperType(targetType) : targetType;
        if (targetType.isInstance(object) && !Iterable.class.isInstance(object) && !Map.class.isInstance(object)) {
            return Optional.of(object);
        }
        Optional<String> formattingAnn = context.getAnnotationMetadata().getAnnotationNameByStereotype(Format.class);
        String formattingAnnotation = formattingAnn.orElse(null);
        ConvertiblePair pair = new ConvertiblePair(sourceType, targetType, formattingAnnotation);
        TypeConverter typeConverter = this.converterCache.get(pair);
        if (typeConverter == null) {
            typeConverter = this.findTypeConverter(sourceType, targetType, formattingAnnotation);
            if (typeConverter == null) {
                return Optional.empty();
            }
            this.converterCache.put(pair, typeConverter);
            if (typeConverter == UNCONVERTIBLE) {
                return Optional.empty();
            }
            return typeConverter.convert(object, targetType, context);
        }
        if (typeConverter != UNCONVERTIBLE) {
            return typeConverter.convert(object, targetType, context);
        }
        return Optional.empty();
    }

    @Override
    public <S, T> boolean canConvert(Class<S> sourceType, Class<T> targetType) {
        ConvertiblePair pair = new ConvertiblePair(sourceType, targetType, null);
        TypeConverter typeConverter = this.converterCache.get(pair);
        if (typeConverter == null) {
            typeConverter = this.findTypeConverter(sourceType, targetType, null);
            if (typeConverter != null) {
                this.converterCache.put(pair, typeConverter);
                return typeConverter != UNCONVERTIBLE;
            }
            return false;
        }
        return typeConverter != UNCONVERTIBLE;
    }

    @Override
    public <S, T> DefaultConversionService addConverter(Class<S> sourceType, Class<T> targetType, TypeConverter<S, T> typeConverter) {
        ConvertiblePair pair = this.newPair(sourceType, targetType, typeConverter);
        this.typeConverters.put(pair, typeConverter);
        this.converterCache.put(pair, typeConverter);
        return this;
    }

    @Override
    public <S, T> DefaultConversionService addConverter(Class<S> sourceType, Class<T> targetType, Function<S, T> function) {
        ConvertiblePair pair = new ConvertiblePair(sourceType, targetType);
        TypeConverter<S, T> typeConverter = TypeConverter.of(sourceType, targetType, function);
        this.typeConverters.put(pair, typeConverter);
        this.converterCache.put(pair, typeConverter);
        return this;
    }

    protected void registerDefaultConverters() {
        this.addConverter((Class)Double[].class, (Class)double[].class, (object, targetType, context) -> {
            double[] doubles = new double[((Double[])object).length];
            for (int i = 0; i < ((Double[])object).length; ++i) {
                Double aDouble = object[i];
                if (aDouble == null) continue;
                doubles[i] = aDouble;
            }
            return Optional.of(doubles);
        });
        this.addConverter((Class)Integer[].class, (Class)int[].class, (object, targetType, context) -> {
            int[] integers = new int[((Integer[])object).length];
            for (int i = 0; i < ((Integer[])object).length; ++i) {
                Integer o = object[i];
                if (o == null) continue;
                integers[i] = o;
            }
            return Optional.of(integers);
        });
        this.addConverter((Class)Object.class, (Class)List.class, (object, targetType, context) -> {
            Optional<Argument<?>> firstTypeVariable = context.getFirstTypeVariable();
            Argument<Object> argument = firstTypeVariable.orElse(Argument.OBJECT_ARGUMENT);
            Optional<Object> converted = this.convert(object, context.with(argument));
            if (converted.isPresent()) {
                return Optional.of(Collections.singletonList(converted.get()));
            }
            return Optional.empty();
        });
        this.addConverter((Class)CharSequence.class, (Class)Class.class, (object, targetType, context) -> {
            ClassLoader classLoader = targetType.getClassLoader();
            if (classLoader == null) {
                classLoader = DefaultConversionService.class.getClassLoader();
            }
            return ClassUtils.forName(object.toString(), classLoader);
        });
        this.addConverter((Class)AnnotationClassValue.class, (Class)Class.class, (object, targetType, context) -> object.getType());
        this.addConverter((Class)AnnotationClassValue.class, (Class)Object.class, (object, targetType, context) -> {
            if (targetType.equals(Class.class)) {
                return object.getType();
            }
            if (CharSequence.class.isAssignableFrom(targetType)) {
                return Optional.of(object.getName());
            }
            Optional i = object.getInstance();
            if (i.isPresent() && targetType.isInstance(i.get())) {
                return i;
            }
            return Optional.empty();
        });
        this.addConverter((Class)AnnotationClassValue[].class, (Class)Class.class, (object, targetType, context) -> {
            AnnotationClassValue o;
            if (((AnnotationClassValue[])object).length > 0 && (o = object[0]) != null) {
                return o.getType();
            }
            return Optional.empty();
        });
        this.addConverter((Class)AnnotationClassValue[].class, (Class)Class[].class, (object, targetType, context) -> {
            ArrayList classes = new ArrayList(((AnnotationClassValue[])object).length);
            for (AnnotationClassValue annotationClassValue : object) {
                Optional type;
                if (annotationClassValue == null || !(type = annotationClassValue.getType()).isPresent()) continue;
                classes.add(type.get());
            }
            return Optional.of(classes.toArray(new Class[0]));
        });
        this.addConverter((Class)URI.class, (Class)URL.class, (T uri) -> {
            try {
                return uri.toURL();
            }
            catch (MalformedURLException e) {
                return null;
            }
        });
        this.addConverter((Class)InputStream.class, (Class)String.class, (object, targetType, context) -> {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)object));
            try {
                return Optional.of(IOUtils.readText(reader));
            }
            catch (IOException e) {
                context.reject(e);
                return Optional.empty();
            }
        });
        this.addConverter((Class)CharSequence.class, (Class)byte[].class, (object, targetType, context) -> Optional.of(object.toString().getBytes(context.getCharset())));
        this.addConverter((Class)Integer.class, (Class)byte[].class, (object, targetType, context) -> Optional.of(java.nio.ByteBuffer.allocate(4).putInt((int)object).array()));
        this.addConverter((Class)Character.class, (Class)byte[].class, (object, targetType, context) -> Optional.of(java.nio.ByteBuffer.allocate(4).putChar(object.charValue()).array()));
        this.addConverter((Class)Long.class, (Class)byte[].class, (object, targetType, context) -> Optional.of(java.nio.ByteBuffer.allocate(8).putLong((long)object).array()));
        this.addConverter((Class)Short.class, (Class)byte[].class, (object, targetType, context) -> Optional.of(java.nio.ByteBuffer.allocate(2).putShort((short)object).array()));
        this.addConverter((Class)Double.class, (Class)byte[].class, (object, targetType, context) -> Optional.of(java.nio.ByteBuffer.allocate(8).putDouble((double)object).array()));
        this.addConverter((Class)Float.class, (Class)byte[].class, (object, targetType, context) -> Optional.of(java.nio.ByteBuffer.allocate(4).putFloat(object.floatValue()).array()));
        this.addConverter((Class)InputStream.class, (Class)Number.class, (object, targetType, context) -> {
            Optional<String> convert = this.convert(object, String.class, context);
            if (convert.isPresent()) {
                return convert.flatMap(val -> this.convert(val, targetType, context));
            }
            return Optional.empty();
        });
        this.addConverter((Class)Reader.class, (Class)String.class, (object, targetType, context) -> {
            BufferedReader reader = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object);
            try {
                return Optional.of(IOUtils.readText(reader));
            }
            catch (IOException e) {
                context.reject(e);
                return Optional.empty();
            }
        });
        this.addConverter((Class)CharSequence.class, (Class)File.class, (object, targetType, context) -> {
            if (StringUtils.isEmpty(object)) {
                return Optional.empty();
            }
            return Optional.of(new File(object.toString()));
        });
        this.addConverter((Class)String[].class, (Class)Enum.class, (object, targetType, context) -> {
            if (object == null || ((String[])object).length == 0) {
                return Optional.empty();
            }
            StringJoiner joiner = new StringJoiner("");
            for (String string : object) {
                joiner.add(string);
            }
            String val = joiner.toString();
            return this.convert(val, targetType, context);
        });
        this.addConverter((Class)String[].class, (Class)CharSequence.class, (object, targetType, context) -> {
            if (object == null || ((String[])object).length == 0) {
                return Optional.empty();
            }
            StringJoiner joiner = new StringJoiner("");
            for (String string : object) {
                joiner.add(string);
            }
            return this.convert(joiner.toString(), targetType, context);
        });
        this.addConverter((Class)CharSequence.class, (Class)Number.class, (TypeConverter)new ReadableBytesTypeConverter());
        this.addConverter((Class)CharSequence.class, (Class)Date.class, (object, targetType, context) -> {
            if (StringUtils.isEmpty(object)) {
                return Optional.empty();
            }
            try {
                SimpleDateFormat format = this.resolveFormat(context);
                return Optional.of(format.parse(object.toString()));
            }
            catch (ParseException e) {
                context.reject(object, e);
                return Optional.empty();
            }
        });
        this.addConverter((Class)Date.class, (Class)CharSequence.class, (object, targetType, context) -> {
            SimpleDateFormat format = this.resolveFormat(context);
            return Optional.of(format.format((Date)object));
        });
        this.addConverter((Class)CharSequence.class, (Class)Path.class, (object, targetType, context) -> {
            if (StringUtils.isEmpty(object)) {
                return Optional.empty();
            }
            try {
                return Optional.ofNullable(Paths.get(object.toString(), new String[0]));
            }
            catch (Exception e) {
                context.reject("Invalid path [" + object + " ]: " + e.getMessage(), e);
                return Optional.empty();
            }
        });
        this.addConverter((Class)CharSequence.class, (Class)Integer.class, (object, targetType, context) -> {
            if (StringUtils.isEmpty(object)) {
                return Optional.empty();
            }
            try {
                Integer converted = Integer.valueOf(object.toString());
                return Optional.of(converted);
            }
            catch (NumberFormatException e) {
                context.reject(object, e);
                return Optional.empty();
            }
        });
        this.addConverter((Class)CharSequence.class, (Class)BigInteger.class, (object, targetType, context) -> {
            if (StringUtils.isEmpty(object)) {
                return Optional.empty();
            }
            try {
                BigInteger converted = new BigInteger(object.toString());
                return Optional.of(converted);
            }
            catch (NumberFormatException e) {
                context.reject(object, e);
                return Optional.empty();
            }
        });
        this.addConverter((Class)CharSequence.class, (Class)Float.class, (object, targetType, context) -> {
            if (StringUtils.isEmpty(object)) {
                return Optional.empty();
            }
            try {
                Float converted = Float.valueOf(object.toString());
                return Optional.of(converted);
            }
            catch (NumberFormatException e) {
                context.reject(object, e);
                return Optional.empty();
            }
        });
        this.addConverter((Class)CharSequence.class, (Class)Double.class, (object, targetType, context) -> {
            if (StringUtils.isEmpty(object)) {
                return Optional.empty();
            }
            try {
                Double converted = Double.valueOf(object.toString());
                return Optional.of(converted);
            }
            catch (NumberFormatException e) {
                context.reject(object, e);
                return Optional.empty();
            }
        });
        this.addConverter((Class)CharSequence.class, (Class)Long.class, (object, targetType, context) -> {
            if (StringUtils.isEmpty(object)) {
                return Optional.empty();
            }
            try {
                Long converted = Long.valueOf(object.toString());
                return Optional.of(converted);
            }
            catch (NumberFormatException e) {
                context.reject(object, e);
                return Optional.empty();
            }
        });
        this.addConverter((Class)CharSequence.class, (Class)Short.class, (object, targetType, context) -> {
            if (StringUtils.isEmpty(object)) {
                return Optional.empty();
            }
            try {
                Short converted = Short.valueOf(object.toString());
                return Optional.of(converted);
            }
            catch (NumberFormatException e) {
                context.reject(object, e);
                return Optional.empty();
            }
        });
        this.addConverter((Class)CharSequence.class, (Class)Byte.class, (object, targetType, context) -> {
            if (StringUtils.isEmpty(object)) {
                return Optional.empty();
            }
            try {
                Byte converted = Byte.valueOf(object.toString());
                return Optional.of(converted);
            }
            catch (NumberFormatException e) {
                context.reject(object, e);
                return Optional.empty();
            }
        });
        this.addConverter((Class)CharSequence.class, (Class)BigDecimal.class, (object, targetType, context) -> {
            if (StringUtils.isEmpty(object)) {
                return Optional.empty();
            }
            try {
                BigDecimal converted = new BigDecimal(object.toString());
                return Optional.of(converted);
            }
            catch (NumberFormatException e) {
                context.reject(object, e);
                return Optional.empty();
            }
        });
        this.addConverter((Class)CharSequence.class, (Class)Boolean.class, (object, targetType, context) -> {
            String booleanString;
            switch (booleanString = object.toString().toLowerCase(Locale.ENGLISH)) {
                case "yes": 
                case "y": 
                case "on": 
                case "true": {
                    return Optional.of(Boolean.TRUE);
                }
            }
            return Optional.of(Boolean.FALSE);
        });
        this.addConverter((Class)CharSequence.class, (Class)URL.class, (object, targetType, context) -> {
            if (StringUtils.isEmpty(object)) {
                return Optional.empty();
            }
            try {
                String spec = object.toString();
                if (!spec.contains("://")) {
                    spec = "http://" + spec;
                }
                return Optional.of(new URL(spec));
            }
            catch (MalformedURLException e) {
                context.reject(object, e);
                return Optional.empty();
            }
        });
        this.addConverter((Class)CharSequence.class, (Class)URI.class, (object, targetType, context) -> {
            if (StringUtils.isEmpty(object)) {
                return Optional.empty();
            }
            try {
                return Optional.of(new URI(object.toString()));
            }
            catch (URISyntaxException e) {
                context.reject(object, e);
                return Optional.empty();
            }
        });
        this.addConverter((Class)CharSequence.class, (Class)Locale.class, (object, targetType, context) -> {
            if (StringUtils.isEmpty(object)) {
                return Optional.empty();
            }
            try {
                return Optional.of(Locale.forLanguageTag(object.toString().replace('_', '-')));
            }
            catch (IllegalArgumentException e) {
                context.reject(object, e);
                return Optional.empty();
            }
        });
        this.addConverter((Class)CharSequence.class, (Class)UUID.class, (object, targetType, context) -> {
            if (StringUtils.isEmpty(object)) {
                return Optional.empty();
            }
            try {
                return Optional.of(UUID.fromString(object.toString()));
            }
            catch (IllegalArgumentException e) {
                context.reject(object, e);
                return Optional.empty();
            }
        });
        this.addConverter((Class)CharSequence.class, (Class)Currency.class, (object, targetType, context) -> {
            if (StringUtils.isEmpty(object)) {
                return Optional.empty();
            }
            try {
                return Optional.of(Currency.getInstance(object.toString()));
            }
            catch (IllegalArgumentException e) {
                context.reject(object, e);
                return Optional.empty();
            }
        });
        this.addConverter((Class)CharSequence.class, (Class)TimeZone.class, (object, targetType, context) -> {
            if (StringUtils.isEmpty(object)) {
                return Optional.empty();
            }
            return Optional.of(TimeZone.getTimeZone(object.toString()));
        });
        this.addConverter((Class)CharSequence.class, (Class)Charset.class, (object, targetType, context) -> {
            if (StringUtils.isEmpty(object)) {
                return Optional.empty();
            }
            try {
                return Optional.of(Charset.forName(object.toString()));
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
                context.reject(object, e);
                return Optional.empty();
            }
        });
        this.addConverter((Class)CharSequence.class, (Class)Character.class, (object, targetType, context) -> {
            String str = object.toString();
            if (str.length() == 1) {
                return Optional.of(Character.valueOf(str.charAt(0)));
            }
            return Optional.empty();
        });
        this.addConverter((Class)CharSequence.class, (Class)Object[].class, (object, targetType, context) -> {
            if (object instanceof AnnotationClassValue && targetType.equals(AnnotationClassValue[].class)) {
                AnnotationClassValue[] array = new AnnotationClassValue[]{(AnnotationClassValue)object};
                return Optional.of(array);
            }
            String str = object.toString();
            String[] strings = str.split(",");
            Class componentType = ReflectionUtils.getWrapperType(targetType.getComponentType());
            Object newArray = Array.newInstance(componentType, strings.length);
            for (int i = 0; i < strings.length; ++i) {
                String string = strings[i];
                Optional converted = this.convert((Object)string, componentType);
                if (!converted.isPresent()) continue;
                Array.set(newArray, i, converted.get());
            }
            return Optional.of((Object[])newArray);
        });
        this.addConverter((Class)CharSequence.class, (Class)int[].class, (object, targetType, context) -> {
            String str = object.toString();
            String[] strings = str.split(",");
            Object newArray = Array.newInstance(Integer.TYPE, strings.length);
            for (int i = 0; i < strings.length; ++i) {
                String string = strings[i];
                Optional<Integer> converted = this.convert((Object)string, Integer.TYPE);
                if (!converted.isPresent()) continue;
                Array.set(newArray, i, converted.get());
            }
            return Optional.of((int[])newArray);
        });
        this.addConverter((Class)Object[].class, (Class)String[].class, (object, targetType, context) -> {
            String[] strings = new String[((Object[])object).length];
            for (int i = 0; i < ((Object[])object).length; ++i) {
                Object o = object[i];
                if (o == null) continue;
                strings[i] = o.toString();
            }
            return Optional.of(strings);
        });
        this.addConverter((Class)CharSequence.class, (Class)Enum.class, (object, targetType, context) -> {
            if (StringUtils.isEmpty(object)) {
                return Optional.empty();
            }
            String stringValue = object.toString();
            try {
                Object val2 = Enum.valueOf(targetType, stringValue);
                return Optional.of(val2);
            }
            catch (IllegalArgumentException e) {
                try {
                    Object val3 = Enum.valueOf(targetType, NameUtils.environmentName(stringValue));
                    return Optional.of(val3);
                }
                catch (Exception e1) {
                    Optional<Enum> valOpt = Arrays.stream(targetType.getEnumConstants()).filter(val -> val.toString().equals(stringValue)).findFirst();
                    if (valOpt.isPresent()) {
                        return valOpt;
                    }
                    context.reject(object, e);
                    return Optional.empty();
                }
            }
        });
        this.addConverter((Class)Object.class, (Class)String.class, (object, targetType, context) -> Optional.of(object.toString()));
        this.addConverter((Class)Number.class, (Class)Number.class, (object, targetType, context) -> {
            Class targetNumberType = ReflectionUtils.getWrapperType(targetType);
            if (targetNumberType.isInstance(object)) {
                return Optional.of(object);
            }
            if (targetNumberType == Integer.class) {
                return Optional.of(object.intValue());
            }
            if (targetNumberType == Long.class) {
                return Optional.of(object.longValue());
            }
            if (targetNumberType == Short.class) {
                return Optional.of(object.shortValue());
            }
            if (targetNumberType == Byte.class) {
                return Optional.of(object.byteValue());
            }
            if (targetNumberType == Float.class) {
                return Optional.of(Float.valueOf(object.floatValue()));
            }
            if (targetNumberType == Double.class) {
                return Optional.of(object.doubleValue());
            }
            if (targetNumberType == BigInteger.class) {
                if (object instanceof BigDecimal) {
                    return Optional.of(((BigDecimal)object).toBigInteger());
                }
                return Optional.of(BigInteger.valueOf(object.longValue()));
            }
            if (targetNumberType == BigDecimal.class) {
                return Optional.of(new BigDecimal(object.toString()));
            }
            return Optional.empty();
        });
        this.addConverter((Class)CharSequence.class, (Class)Iterable.class, (object, targetType, context) -> {
            Optional<Argument<?>> typeVariable = context.getFirstTypeVariable();
            Argument<Object> componentType = typeVariable.orElse(Argument.OBJECT_ARGUMENT);
            ArgumentConversionContext<Object> newContext = context.with(componentType);
            Class targetComponentType = ReflectionUtils.getWrapperType(componentType.getType());
            String[] strings = object.toString().split(",");
            ArrayList list = new ArrayList();
            for (String string : strings) {
                Optional converted = this.convert(string, targetComponentType, newContext);
                if (!converted.isPresent()) continue;
                list.add(converted.get());
            }
            return CollectionUtils.convertCollection(targetType, list);
        });
        TypeConverter objectToOptionalConverter = (object, targetType, context) -> {
            ArgumentConversionContext<Object> newContext;
            Optional<Argument<?>> typeVariable = context.getFirstTypeVariable();
            Argument<Object> componentType = typeVariable.orElse(Argument.OBJECT_ARGUMENT);
            Class targetComponentType = ReflectionUtils.getWrapperType(componentType.getType());
            Optional converted = this.convert(object, targetComponentType, newContext = context.with(componentType).with(context.getAnnotationMetadata()));
            if (converted.isPresent()) {
                return Optional.of(converted);
            }
            return Optional.of(Optional.empty());
        };
        this.addConverter((Class)Object.class, (Class)Optional.class, objectToOptionalConverter);
        this.addConverter((Class)Object.class, (Class)OptionalInt.class, (object, targetType, context) -> {
            Optional<Integer> converted = this.convert(object, Integer.class, context);
            return converted.map(integer -> Optional.of(OptionalInt.of(integer))).orElseGet(() -> Optional.of(OptionalInt.empty()));
        });
        this.addConverter((Class)Object.class, (Class)OptionalLong.class, (object, targetType, context) -> {
            Optional<Long> converted = this.convert(object, Long.class, context);
            return converted.map(longValue -> Optional.of(OptionalLong.of(longValue))).orElseGet(() -> Optional.of(OptionalLong.empty()));
        });
        this.addConverter((Class)Iterable.class, (Class)String.class, (object, targetType, context) -> Optional.of(CollectionUtils.toString(object)));
        this.addConverter((Class)Iterable.class, (Class)Object.class, (object, targetType, context) -> {
            if (Optional.class.isAssignableFrom(targetType)) {
                return objectToOptionalConverter.convert(object, targetType, context);
            }
            Iterator i = object.iterator();
            int count = 0;
            Object value = null;
            while (i.hasNext()) {
                if (count > 0) {
                    context.reject(object, new ConversionErrorException(Argument.of(targetType), new IllegalArgumentException("Cannot convert an iterable with more than 1 value to a non collection object")));
                    return Optional.empty();
                }
                ++count;
                value = i.next();
            }
            return this.convert(value, targetType, context);
        });
        this.addConverter((Class)Iterable.class, (Class)Iterable.class, (object, targetType, context) -> {
            if (ConvertibleValues.class.isAssignableFrom(targetType)) {
                if (object instanceof ConvertibleValues) {
                    return Optional.of(object);
                }
                return Optional.empty();
            }
            Optional<Argument<?>> typeVariable = context.getFirstTypeVariable();
            Argument<Object> componentType = typeVariable.orElse(Argument.OBJECT_ARGUMENT);
            Class targetComponentType = ReflectionUtils.getWrapperType(componentType.getType());
            ArgumentConversionContext<Object> newContext = context.with(componentType);
            if (targetType.isInstance(object) && targetComponentType == Object.class) {
                return Optional.of(object);
            }
            ArrayList list = new ArrayList();
            for (Object o : object) {
                Optional converted = this.convert(o, targetComponentType, newContext);
                if (!converted.isPresent()) continue;
                list.add(converted.get());
            }
            return CollectionUtils.convertCollection(targetType, list);
        });
        this.addConverter((Class)Object[].class, (Class)String.class, (object, targetType, context) -> Optional.of(ArrayUtils.toString(object)));
        this.addConverter((Class)Object[].class, (Class)Object[].class, (object, targetType, context) -> {
            Class<?> targetComponentType = targetType.getComponentType();
            ArrayList results = new ArrayList();
            for (Object o : object) {
                Optional<?> converted = this.convert(o, targetComponentType, context);
                if (!converted.isPresent()) continue;
                results.add(converted.get());
            }
            return Optional.of(results.toArray((Object[])Array.newInstance(targetComponentType, results.size())));
        });
        this.addConverter((Class)Iterable.class, (Class)Object[].class, (object, targetType, context) -> {
            Class<?> targetComponentType = targetType.getComponentType();
            ArrayList results = new ArrayList();
            for (Object o : object) {
                Optional<?> converted = this.convert(o, targetComponentType, context);
                if (!converted.isPresent()) continue;
                results.add(converted.get());
            }
            return Optional.of(results.toArray((Object[])Array.newInstance(targetComponentType, results.size())));
        });
        this.addConverter((Class)Object[].class, (Class)Iterable.class, (object, targetType, context) -> this.convert(Arrays.asList(object), targetType, context));
        this.addConverter((Class)Object.class, (Class)Object[].class, (object, targetType, context) -> {
            Class<?> targetComponentType = targetType.getComponentType();
            Optional<?> converted = this.convert(object, targetComponentType);
            if (converted.isPresent()) {
                Object[] result = (Object[])Array.newInstance(targetComponentType, 1);
                result[0] = converted.get();
                return Optional.of(result);
            }
            return Optional.empty();
        });
        this.addConverter((Class)Map.class, (Class)Map.class, (object, targetType, context) -> {
            Argument<String> keyArgument = context.getTypeVariable("K").orElse(Argument.of(String.class, "K"));
            boolean isProperties = targetType.equals(Properties.class);
            Argument valArgument = context.getTypeVariable("V").orElseGet(() -> {
                if (isProperties) {
                    return Argument.of(String.class, "V");
                }
                return Argument.of(Object.class, "V");
            });
            Class<String> keyType = keyArgument.getType();
            Class valueType = valArgument.getType();
            ArgumentConversionContext<String> keyContext = context.with(keyArgument);
            ArgumentConversionContext valContext = context.with(valArgument);
            Map<Object, Object> newMap = isProperties ? new Properties() : new LinkedHashMap();
            Iterator iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = iterator.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (!keyType.isInstance(key)) {
                    Optional<String> convertedKey = this.convert(key, keyType, keyContext);
                    if (!convertedKey.isPresent()) continue;
                    key = convertedKey.get();
                }
                if (!valueType.isInstance(value) || Map.class.isAssignableFrom(valueType)) {
                    Optional converted = this.convert(value, valueType, valContext);
                    if (!converted.isPresent()) continue;
                    value = converted.get();
                }
                newMap.put(key, value);
            }
            return Optional.of(newMap);
        });
        this.addConverter((Class)Map.class, (Class)ConvertibleValues.class, (object, targetType, context) -> Optional.of(new ConvertibleValuesMap(object)));
        this.addConverter((Class)ByteBuffer.class, (Class)byte[].class, (object, targetType, context) -> {
            byte[] result = object.toByteArray();
            ((ReferenceCounted)((Object)object)).release();
            return Optional.of(result);
        });
    }

    protected <T> TypeConverter findTypeConverter(Class<?> sourceType, Class<T> targetType, String formattingAnnotation) {
        ConvertiblePair pair;
        TypeConverter typeConverter = UNCONVERTIBLE;
        List<Class> sourceHierarchy = ClassUtils.resolveHierarchy(sourceType);
        List<Class> targetHierarchy = ClassUtils.resolveHierarchy(targetType);
        boolean hasFormatting = formattingAnnotation != null;
        for (Class sourceSuperType : sourceHierarchy) {
            for (Class targetSuperType : targetHierarchy) {
                pair = new ConvertiblePair(sourceSuperType, targetSuperType, formattingAnnotation);
                typeConverter = this.typeConverters.get(pair);
                if (typeConverter == null) continue;
                this.converterCache.put(pair, typeConverter);
                return typeConverter;
            }
        }
        if (hasFormatting) {
            for (Class sourceSuperType : sourceHierarchy) {
                for (Class targetSuperType : targetHierarchy) {
                    pair = new ConvertiblePair(sourceSuperType, targetSuperType);
                    typeConverter = this.typeConverters.get(pair);
                    if (typeConverter == null) continue;
                    this.converterCache.put(pair, typeConverter);
                    return typeConverter;
                }
            }
        }
        return typeConverter;
    }

    private SimpleDateFormat resolveFormat(ConversionContext context) {
        AnnotationMetadata annotationMetadata = context.getAnnotationMetadata();
        Optional<String> format = annotationMetadata.stringValue(Format.class);
        return format.map(pattern -> new SimpleDateFormat((String)pattern, context.getLocale())).orElse(new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", context.getLocale()));
    }

    private <S, T> ConvertiblePair newPair(Class<S> sourceType, Class<T> targetType, TypeConverter<S, T> typeConverter) {
        ConvertiblePair pair = typeConverter instanceof FormattingTypeConverter ? new ConvertiblePair(sourceType, targetType, ((FormattingTypeConverter)typeConverter).annotationType().getName()) : new ConvertiblePair(sourceType, targetType);
        return pair;
    }

    private final class ConvertiblePair {
        final Class source;
        final Class target;
        final String formattingAnnotation;

        ConvertiblePair(Class source, Class target) {
            this(source, target, null);
        }

        ConvertiblePair(Class source, Class target, String formattingAnnotation) {
            this.source = source;
            this.target = target;
            this.formattingAnnotation = formattingAnnotation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConvertiblePair pair = (ConvertiblePair)o;
            if (!this.source.equals(pair.source)) {
                return false;
            }
            if (!this.target.equals(pair.target)) {
                return false;
            }
            return this.formattingAnnotation != null ? this.formattingAnnotation.equals(pair.formattingAnnotation) : pair.formattingAnnotation == null;
        }

        public int hashCode() {
            int result = this.source.hashCode();
            result = 31 * result + this.target.hashCode();
            result = 31 * result + (this.formattingAnnotation != null ? this.formattingAnnotation.hashCode() : 0);
            return result;
        }
    }
}

