/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.qualifiers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.BeanType;
import io.micronaut.inject.qualifiers.NameQualifier;
import java.lang.annotation.Annotation;
import java.util.stream.Stream;
import javax.inject.Named;

@Internal
class AnnotationQualifier<T>
extends NameQualifier<T> {
    private final Annotation qualifier;

    AnnotationQualifier(Annotation qualifier) {
        super(qualifier.annotationType().getSimpleName());
        this.qualifier = qualifier;
    }

    @Override
    public <BT extends BeanType<T>> Stream<BT> reduce(Class<T> beanType, Stream<BT> candidates) {
        String name;
        if (this.qualifier instanceof Named) {
            Named named = (Named)this.qualifier;
            String v = named.value();
            name = Character.toUpperCase(v.charAt(0)) + v.substring(1);
        } else {
            name = this.qualifier.annotationType().getSimpleName();
        }
        return this.reduceByAnnotation(beanType, candidates, name, this.qualifier.annotationType().getName());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationQualifier that = (AnnotationQualifier)o;
        return this.qualifier.equals(that.qualifier);
    }

    @Override
    public int hashCode() {
        return this.qualifier.hashCode();
    }

    @Override
    public String toString() {
        return '@' + this.qualifier.annotationType().getSimpleName();
    }
}

