/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.frame.individual;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.inference.ReasonerPreferences;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.editor.OWLObjectPropertyIndividualPairEditor2;
import org.protege.editor.owl.ui.frame.AbstractOWLFrameSection;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.protege.editor.owl.ui.frame.OWLObjectPropertyIndividualPair;
import org.protege.editor.owl.ui.frame.individual.OWLObjectPropertyAssertionAxiomFrameSectionRow;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.reasoner.NodeSet;

public class OWLObjectPropertyAssertionAxiomFrameSection
extends AbstractOWLFrameSection<OWLIndividual, OWLObjectPropertyAssertionAxiom, OWLObjectPropertyIndividualPair> {
    public static final String LABEL = "Object property assertions";
    private final Set<OWLObjectPropertyAssertionAxiom> added = new HashSet<OWLObjectPropertyAssertionAxiom>();
    private final OWLObjectPropertyIndividualPairEditor2 editor = new OWLObjectPropertyIndividualPairEditor2(this.getOWLEditorKit());

    public OWLObjectPropertyAssertionAxiomFrameSection(OWLEditorKit owlEditorKit, OWLFrame<? extends OWLIndividual> frame) {
        super(owlEditorKit, LABEL, "Object property assertion", frame);
    }

    @Override
    protected void clear() {
        this.added.clear();
    }

    @Override
    protected void refill(OWLOntology ontology) {
        for (OWLObjectPropertyAssertionAxiom ax : ontology.getObjectPropertyAssertionAxioms((OWLIndividual)this.getRootObject())) {
            this.addRow(new OWLObjectPropertyAssertionAxiomFrameSectionRow(this.getOWLEditorKit(), this, ontology, (OWLIndividual)this.getRootObject(), ax));
            this.added.add(ax);
        }
    }

    @Override
    protected void refillInferred() {
        this.getOWLModelManager().getReasonerPreferences().executeTask(ReasonerPreferences.OptionalInferenceTask.SHOW_INFERRED_OBJECT_PROPERTY_ASSERTIONS, () -> {
            if (!this.getOWLModelManager().getReasoner().isConsistent()) {
                return;
            }
            OWLDataFactory factory = this.getOWLDataFactory();
            if (!((OWLIndividual)this.getRootObject()).isAnonymous()) {
                for (OWLObjectProperty prop : this.getReasoner().getRootOntology().getObjectPropertiesInSignature(true)) {
                    if (prop.equals(factory.getOWLTopObjectProperty())) continue;
                    NodeSet values = this.getReasoner().getObjectPropertyValues(((OWLIndividual)this.getRootObject()).asOWLNamedIndividual(), (OWLObjectPropertyExpression)prop);
                    for (OWLNamedIndividual ind : values.getFlattened()) {
                        OWLObjectPropertyAssertionAxiom ax = this.getOWLDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)prop, (OWLIndividual)this.getRootObject(), (OWLIndividual)ind);
                        if (this.added.contains(ax)) continue;
                        this.addRow(new OWLObjectPropertyAssertionAxiomFrameSectionRow(this.getOWLEditorKit(), this, null, (OWLIndividual)this.getRootObject(), ax));
                    }
                }
            }
        });
    }

    @Override
    protected OWLObjectPropertyAssertionAxiom createAxiom(OWLObjectPropertyIndividualPair object) {
        return this.getOWLDataFactory().getOWLObjectPropertyAssertionAxiom(object.getProperty(), (OWLIndividual)this.getRootObject(), object.getIndividual());
    }

    @Override
    public OWLObjectEditor<OWLObjectPropertyIndividualPair> getObjectEditor() {
        return this.editor;
    }

    @Override
    public Comparator<OWLFrameSectionRow<OWLIndividual, OWLObjectPropertyAssertionAxiom, OWLObjectPropertyIndividualPair>> getRowComparator() {
        return null;
    }

    @Override
    protected boolean isResettingChange(OWLOntologyChange change) {
        if (!change.isAxiomChange()) {
            return false;
        }
        OWLAxiom axiom = change.getAxiom();
        if (axiom instanceof OWLObjectPropertyAssertionAxiom) {
            return ((OWLObjectPropertyAssertionAxiom)axiom).getSubject().equals(this.getRootObject());
        }
        return false;
    }
}

