/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer.styledstring;

import com.google.common.base.Preconditions;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.text.AttributedString;

public class TextLayoutCache {
    private final AttributedString attributedString;
    private FontRenderContext cachedFontRenderContext;
    private TextLayout cachedLayout;

    public TextLayoutCache(AttributedString attributedString) {
        this.attributedString = (AttributedString)Preconditions.checkNotNull((Object)attributedString);
    }

    public AttributedString getAttributedString() {
        return this.attributedString;
    }

    public TextLayout getTextLayout(FontRenderContext fontRenderContext) {
        if (!this.isCachedFontRenderContext(fontRenderContext)) {
            this.cachedLayout = new TextLayout(this.attributedString.getIterator(), fontRenderContext);
            this.cachedFontRenderContext = fontRenderContext;
        }
        return this.cachedLayout;
    }

    public float getHeight(FontRenderContext fontRenderContext) {
        TextLayout tl = this.getTextLayout(fontRenderContext);
        return tl.getLeading() + tl.getAscent() + tl.getDescent();
    }

    public float getVisibleAdvance(FontRenderContext fontRenderContext) {
        TextLayout tl = this.getTextLayout(fontRenderContext);
        return tl.getVisibleAdvance();
    }

    public float getBaseline(FontRenderContext fontRenderContext) {
        TextLayout tl = this.getTextLayout(fontRenderContext);
        return tl.getLeading() + tl.getAscent();
    }

    private boolean isCachedFontRenderContext(FontRenderContext fontRenderContext) {
        return this.cachedFontRenderContext != null && this.cachedFontRenderContext.equals(fontRenderContext);
    }
}

