/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.gui.datatransfer.data.PrimitiveTransferData;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class RelationMemberTransferable
implements Transferable {
    public static final DataFlavor RELATION_MEMBER_DATA = new DataFlavor(Data.class, "Relation member");
    private final Collection<RelationMember> members;

    public RelationMemberTransferable(Collection<RelationMember> members) {
        this.members = new ArrayList<RelationMember>(members);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{RELATION_MEMBER_DATA, PrimitiveTransferData.DATA_FLAVOR, DataFlavor.stringFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return Arrays.asList(this.getTransferDataFlavors()).contains(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (DataFlavor.stringFlavor.equals(flavor)) {
            return this.getStringData();
        }
        if (RELATION_MEMBER_DATA.equals(flavor)) {
            return this.getRelationMemberData();
        }
        if (PrimitiveTransferData.DATA_FLAVOR.equals(flavor)) {
            return this.getPrimitiveData();
        }
        throw new UnsupportedFlavorException(flavor);
    }

    private PrimitiveTransferData getPrimitiveData() {
        Collection primitives = this.members.stream().map(RelationMember::getMember).collect(Collectors.toSet());
        return PrimitiveTransferData.getData(primitives);
    }

    protected String getStringData() {
        StringBuilder sb = new StringBuilder();
        for (RelationMember member : this.members) {
            sb.append((Object)member.getType()).append(' ').append(member.getUniqueId()).append(' ').append(member.getRole()).append(" # ").append(member.getMember().getDisplayName(DefaultNameFormatter.getInstance())).append('\n');
        }
        return sb.toString().replace("\u200e", "").replace("\u200f", "");
    }

    protected Data getRelationMemberData() {
        return Data.getData(this.members);
    }

    public static final class Data
    implements Serializable {
        private static final long serialVersionUID = -8432393711635811029L;
        private final Collection<RelationMemberData> relationMemberDatas;

        private Data(Collection<RelationMemberData> primitiveData) {
            CheckParameterUtil.ensureThat(primitiveData instanceof Serializable, "primitiveData must be instanceof Serializable");
            this.relationMemberDatas = primitiveData;
        }

        public Collection<RelationMemberData> getRelationMemberData() {
            return Collections.unmodifiableCollection(this.relationMemberDatas);
        }

        public static Data getData(Collection<RelationMember> members) {
            return new Data(members.stream().map(m -> new RelationMemberData(m.getRole(), m.getType(), m.getUniqueId())).collect(Collectors.toList()));
        }
    }
}

